package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Timestamp, UnsubscribeAll, EmailAddress}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Contact(
    emailAddress: Option[EmailAddress] = None,
    topicPreferences: Option[Iterable[zio.aws.sesv2.model.TopicPreference]] =
      None,
    topicDefaultPreferences: Option[
      Iterable[zio.aws.sesv2.model.TopicPreference]
    ] = None,
    unsubscribeAll: Option[UnsubscribeAll] = None,
    lastUpdatedTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.sesv2.model.Contact = {
    import Contact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.Contact
      .builder()
      .optionallyWith(
        emailAddress.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        topicPreferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicPreferences)
      .optionallyWith(
        topicDefaultPreferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicDefaultPreferences)
      .optionallyWith(
        unsubscribeAll.map(value =>
          UnsubscribeAll.unwrap(value): java.lang.Boolean
        )
      )(_.unsubscribeAll)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.Contact.ReadOnly =
    zio.aws.sesv2.model.Contact.wrap(buildAwsValue())
}
object Contact {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.Contact] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.Contact = zio.aws.sesv2.model.Contact(
      emailAddress.map(value => value),
      topicPreferences.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      topicDefaultPreferences.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      unsubscribeAll.map(value => value),
      lastUpdatedTimestamp.map(value => value)
    )
    def emailAddress: Option[EmailAddress]
    def topicPreferences
        : Option[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]]
    def topicDefaultPreferences
        : Option[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]]
    def unsubscribeAll: Option[UnsubscribeAll]
    def lastUpdatedTimestamp: Option[Timestamp]
    def getEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getTopicPreferences: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.TopicPreference.ReadOnly
    ]] = AwsError.unwrapOptionField("topicPreferences", topicPreferences)
    def getTopicDefaultPreferences: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.TopicPreference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "topicDefaultPreferences",
      topicDefaultPreferences
    )
    def getUnsubscribeAll: ZIO[Any, AwsError, UnsubscribeAll] =
      AwsError.unwrapOptionField("unsubscribeAll", unsubscribeAll)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.Contact
  ) extends zio.aws.sesv2.model.Contact.ReadOnly {
    override val emailAddress: Option[EmailAddress] = scala
      .Option(impl.emailAddress())
      .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val topicPreferences
        : Option[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]] = scala
      .Option(impl.topicPreferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.TopicPreference.wrap(item)
        }.toList
      )
    override val topicDefaultPreferences
        : Option[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]] = scala
      .Option(impl.topicDefaultPreferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.TopicPreference.wrap(item)
        }.toList
      )
    override val unsubscribeAll: Option[UnsubscribeAll] = scala
      .Option(impl.unsubscribeAll())
      .map(value => zio.aws.sesv2.model.primitives.UnsubscribeAll(value))
    override val lastUpdatedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.Contact
  ): zio.aws.sesv2.model.Contact.ReadOnly = new Wrapper(impl)
}
