package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Volume
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VolumeStatistics(
    inboxRawCount: Option[Volume] = None,
    spamRawCount: Option[Volume] = None,
    projectedInbox: Option[Volume] = None,
    projectedSpam: Option[Volume] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.VolumeStatistics = {
    import VolumeStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.VolumeStatistics
      .builder()
      .optionallyWith(
        inboxRawCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.inboxRawCount)
      .optionallyWith(
        spamRawCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.spamRawCount)
      .optionallyWith(
        projectedInbox.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.projectedInbox)
      .optionallyWith(
        projectedSpam.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.projectedSpam)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.VolumeStatistics.ReadOnly =
    zio.aws.sesv2.model.VolumeStatistics.wrap(buildAwsValue())
}
object VolumeStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.VolumeStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.VolumeStatistics =
      zio.aws.sesv2.model.VolumeStatistics(
        inboxRawCount.map(value => value),
        spamRawCount.map(value => value),
        projectedInbox.map(value => value),
        projectedSpam.map(value => value)
      )
    def inboxRawCount: Option[Volume]
    def spamRawCount: Option[Volume]
    def projectedInbox: Option[Volume]
    def projectedSpam: Option[Volume]
    def getInboxRawCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("inboxRawCount", inboxRawCount)
    def getSpamRawCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("spamRawCount", spamRawCount)
    def getProjectedInbox: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("projectedInbox", projectedInbox)
    def getProjectedSpam: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("projectedSpam", projectedSpam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.VolumeStatistics
  ) extends zio.aws.sesv2.model.VolumeStatistics.ReadOnly {
    override val inboxRawCount: Option[Volume] = scala
      .Option(impl.inboxRawCount())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val spamRawCount: Option[Volume] = scala
      .Option(impl.spamRawCount())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val projectedInbox: Option[Volume] = scala
      .Option(impl.projectedInbox())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val projectedSpam: Option[Volume] = scala
      .Option(impl.projectedSpam())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.VolumeStatistics
  ): zio.aws.sesv2.model.VolumeStatistics.ReadOnly = new Wrapper(impl)
}
