package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Description, DisplayName, TopicName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Topic(
    topicName: TopicName,
    displayName: DisplayName,
    description: Option[Description] = None,
    defaultSubscriptionStatus: zio.aws.sesv2.model.SubscriptionStatus
) {
  def buildAwsValue(): software.amazon.awssdk.services.sesv2.model.Topic = {
    import Topic.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.Topic
      .builder()
      .topicName(TopicName.unwrap(topicName): java.lang.String)
      .displayName(DisplayName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .defaultSubscriptionStatus(defaultSubscriptionStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.Topic.ReadOnly =
    zio.aws.sesv2.model.Topic.wrap(buildAwsValue())
}
object Topic {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.Topic] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.Topic = zio.aws.sesv2.model.Topic(
      topicName,
      displayName,
      description.map(value => value),
      defaultSubscriptionStatus
    )
    def topicName: TopicName
    def displayName: DisplayName
    def description: Option[Description]
    def defaultSubscriptionStatus: zio.aws.sesv2.model.SubscriptionStatus
    def getTopicName: ZIO[Any, Nothing, TopicName] = ZIO.succeed(topicName)
    def getDisplayName: ZIO[Any, Nothing, DisplayName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultSubscriptionStatus
        : ZIO[Any, Nothing, zio.aws.sesv2.model.SubscriptionStatus] =
      ZIO.succeed(defaultSubscriptionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.Topic
  ) extends zio.aws.sesv2.model.Topic.ReadOnly {
    override val topicName: TopicName =
      zio.aws.sesv2.model.primitives.TopicName(impl.topicName())
    override val displayName: DisplayName =
      zio.aws.sesv2.model.primitives.DisplayName(impl.displayName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.sesv2.model.primitives.Description(value))
    override val defaultSubscriptionStatus
        : zio.aws.sesv2.model.SubscriptionStatus =
      zio.aws.sesv2.model.SubscriptionStatus
        .wrap(impl.defaultSubscriptionStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.Topic
  ): zio.aws.sesv2.model.Topic.ReadOnly = new Wrapper(impl)
}
