package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.OutboundMessageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SendEmailResponse(
    messageId: Option[OutboundMessageId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SendEmailResponse = {
    import SendEmailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SendEmailResponse
      .builder()
      .optionallyWith(
        messageId.map(value =>
          OutboundMessageId.unwrap(value): java.lang.String
        )
      )(_.messageId)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SendEmailResponse.ReadOnly =
    zio.aws.sesv2.model.SendEmailResponse.wrap(buildAwsValue())
}
object SendEmailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SendEmailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SendEmailResponse =
      zio.aws.sesv2.model.SendEmailResponse(messageId.map(value => value))
    def messageId: Option[OutboundMessageId]
    def getMessageId: ZIO[Any, AwsError, OutboundMessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SendEmailResponse
  ) extends zio.aws.sesv2.model.SendEmailResponse.ReadOnly {
    override val messageId: Option[OutboundMessageId] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.sesv2.model.primitives.OutboundMessageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SendEmailResponse
  ): zio.aws.sesv2.model.SendEmailResponse.ReadOnly = new Wrapper(impl)
}
