package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  ConfigurationSetName,
  AmazonResourceName,
  EmailAddress
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SendBulkEmailRequest(
    fromEmailAddress: Option[EmailAddress] = None,
    fromEmailAddressIdentityArn: Option[AmazonResourceName] = None,
    replyToAddresses: Option[Iterable[EmailAddress]] = None,
    feedbackForwardingEmailAddress: Option[EmailAddress] = None,
    feedbackForwardingEmailAddressIdentityArn: Option[AmazonResourceName] =
      None,
    defaultEmailTags: Option[Iterable[zio.aws.sesv2.model.MessageTag]] = None,
    defaultContent: zio.aws.sesv2.model.BulkEmailContent,
    bulkEmailEntries: Iterable[zio.aws.sesv2.model.BulkEmailEntry],
    configurationSetName: Option[ConfigurationSetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest = {
    import SendBulkEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest
      .builder()
      .optionallyWith(
        fromEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        fromEmailAddressIdentityArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddressIdentityArn)
      .optionallyWith(
        replyToAddresses.map(value =>
          value.map { item =>
            EmailAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replyToAddresses)
      .optionallyWith(
        feedbackForwardingEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.feedbackForwardingEmailAddress)
      .optionallyWith(
        feedbackForwardingEmailAddressIdentityArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.feedbackForwardingEmailAddressIdentityArn)
      .optionallyWith(
        defaultEmailTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultEmailTags)
      .defaultContent(defaultContent.buildAwsValue())
      .bulkEmailEntries(bulkEmailEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SendBulkEmailRequest.ReadOnly =
    zio.aws.sesv2.model.SendBulkEmailRequest.wrap(buildAwsValue())
}
object SendBulkEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SendBulkEmailRequest =
      zio.aws.sesv2.model.SendBulkEmailRequest(
        fromEmailAddress.map(value => value),
        fromEmailAddressIdentityArn.map(value => value),
        replyToAddresses.map(value => value),
        feedbackForwardingEmailAddress.map(value => value),
        feedbackForwardingEmailAddressIdentityArn.map(value => value),
        defaultEmailTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultContent.asEditable,
        bulkEmailEntries.map { item =>
          item.asEditable
        },
        configurationSetName.map(value => value)
      )
    def fromEmailAddress: Option[EmailAddress]
    def fromEmailAddressIdentityArn: Option[AmazonResourceName]
    def replyToAddresses: Option[List[EmailAddress]]
    def feedbackForwardingEmailAddress: Option[EmailAddress]
    def feedbackForwardingEmailAddressIdentityArn: Option[AmazonResourceName]
    def defaultEmailTags: Option[List[zio.aws.sesv2.model.MessageTag.ReadOnly]]
    def defaultContent: zio.aws.sesv2.model.BulkEmailContent.ReadOnly
    def bulkEmailEntries: List[zio.aws.sesv2.model.BulkEmailEntry.ReadOnly]
    def configurationSetName: Option[ConfigurationSetName]
    def getFromEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getFromEmailAddressIdentityArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField(
        "fromEmailAddressIdentityArn",
        fromEmailAddressIdentityArn
      )
    def getReplyToAddresses: ZIO[Any, AwsError, List[EmailAddress]] =
      AwsError.unwrapOptionField("replyToAddresses", replyToAddresses)
    def getFeedbackForwardingEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField(
        "feedbackForwardingEmailAddress",
        feedbackForwardingEmailAddress
      )
    def getFeedbackForwardingEmailAddressIdentityArn
        : ZIO[Any, AwsError, AmazonResourceName] = AwsError.unwrapOptionField(
      "feedbackForwardingEmailAddressIdentityArn",
      feedbackForwardingEmailAddressIdentityArn
    )
    def getDefaultEmailTags
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.MessageTag.ReadOnly]] =
      AwsError.unwrapOptionField("defaultEmailTags", defaultEmailTags)
    def getDefaultContent
        : ZIO[Any, Nothing, zio.aws.sesv2.model.BulkEmailContent.ReadOnly] =
      ZIO.succeed(defaultContent)
    def getBulkEmailEntries
        : ZIO[Any, Nothing, List[zio.aws.sesv2.model.BulkEmailEntry.ReadOnly]] =
      ZIO.succeed(bulkEmailEntries)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest
  ) extends zio.aws.sesv2.model.SendBulkEmailRequest.ReadOnly {
    override val fromEmailAddress: Option[EmailAddress] = scala
      .Option(impl.fromEmailAddress())
      .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val fromEmailAddressIdentityArn: Option[AmazonResourceName] = scala
      .Option(impl.fromEmailAddressIdentityArn())
      .map(value => zio.aws.sesv2.model.primitives.AmazonResourceName(value))
    override val replyToAddresses: Option[List[EmailAddress]] = scala
      .Option(impl.replyToAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.EmailAddress(item)
        }.toList
      )
    override val feedbackForwardingEmailAddress: Option[EmailAddress] = scala
      .Option(impl.feedbackForwardingEmailAddress())
      .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val feedbackForwardingEmailAddressIdentityArn
        : Option[AmazonResourceName] = scala
      .Option(impl.feedbackForwardingEmailAddressIdentityArn())
      .map(value => zio.aws.sesv2.model.primitives.AmazonResourceName(value))
    override val defaultEmailTags
        : Option[List[zio.aws.sesv2.model.MessageTag.ReadOnly]] = scala
      .Option(impl.defaultEmailTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.MessageTag.wrap(item)
        }.toList
      )
    override val defaultContent: zio.aws.sesv2.model.BulkEmailContent.ReadOnly =
      zio.aws.sesv2.model.BulkEmailContent.wrap(impl.defaultContent())
    override val bulkEmailEntries
        : List[zio.aws.sesv2.model.BulkEmailEntry.ReadOnly] = impl
      .bulkEmailEntries()
      .asScala
      .map { item =>
        zio.aws.sesv2.model.BulkEmailEntry.wrap(item)
      }
      .toList
    override val configurationSetName: Option[ConfigurationSetName] = scala
      .Option(impl.configurationSetName())
      .map(value => zio.aws.sesv2.model.primitives.ConfigurationSetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest
  ): zio.aws.sesv2.model.SendBulkEmailRequest.ReadOnly = new Wrapper(impl)
}
