package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Enabled, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutEmailIdentityFeedbackAttributesRequest(
    emailIdentity: Identity,
    emailForwardingEnabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest = {
    import PutEmailIdentityFeedbackAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .optionallyWith(
        emailForwardingEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.emailForwardingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesRequest.ReadOnly =
    zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesRequest
      .wrap(buildAwsValue())
}
object PutEmailIdentityFeedbackAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesRequest =
      zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesRequest(
        emailIdentity,
        emailForwardingEnabled.map(value => value)
      )
    def emailIdentity: Identity
    def emailForwardingEnabled: Option[Enabled]
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getEmailForwardingEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("emailForwardingEnabled", emailForwardingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest
  ) extends zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
    override val emailForwardingEnabled: Option[Enabled] = scala
      .Option(impl.emailForwardingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest
  ): zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
