package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Enabled
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutDeliverabilityDashboardOptionRequest(
    dashboardEnabled: Enabled,
    subscribedDomains: Option[
      Iterable[zio.aws.sesv2.model.DomainDeliverabilityTrackingOption]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest = {
    import PutDeliverabilityDashboardOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest
      .builder()
      .dashboardEnabled(Enabled.unwrap(dashboardEnabled): java.lang.Boolean)
      .optionallyWith(
        subscribedDomains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscribedDomains)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutDeliverabilityDashboardOptionRequest.ReadOnly =
    zio.aws.sesv2.model.PutDeliverabilityDashboardOptionRequest
      .wrap(buildAwsValue())
}
object PutDeliverabilityDashboardOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutDeliverabilityDashboardOptionRequest =
      zio.aws.sesv2.model.PutDeliverabilityDashboardOptionRequest(
        dashboardEnabled,
        subscribedDomains.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dashboardEnabled: Enabled
    def subscribedDomains: Option[
      List[zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly]
    ]
    def getDashboardEnabled: ZIO[Any, Nothing, Enabled] =
      ZIO.succeed(dashboardEnabled)
    def getSubscribedDomains: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]] = AwsError.unwrapOptionField("subscribedDomains", subscribedDomains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest
  ) extends zio.aws.sesv2.model.PutDeliverabilityDashboardOptionRequest.ReadOnly {
    override val dashboardEnabled: Enabled =
      zio.aws.sesv2.model.primitives.Enabled(impl.dashboardEnabled())
    override val subscribedDomains: Option[
      List[zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly]
    ] = scala
      .Option(impl.subscribedDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest
  ): zio.aws.sesv2.model.PutDeliverabilityDashboardOptionRequest.ReadOnly =
    new Wrapper(impl)
}
