package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSuppressedDestinationsResponse(
    suppressedDestinationSummaries: Option[
      Iterable[zio.aws.sesv2.model.SuppressedDestinationSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse = {
    import ListSuppressedDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse
      .builder()
      .optionallyWith(
        suppressedDestinationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suppressedDestinationSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly =
    zio.aws.sesv2.model.ListSuppressedDestinationsResponse.wrap(buildAwsValue())
}
object ListSuppressedDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListSuppressedDestinationsResponse =
      zio.aws.sesv2.model.ListSuppressedDestinationsResponse(
        suppressedDestinationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def suppressedDestinationSummaries: Option[
      List[zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getSuppressedDestinationSummaries: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "suppressedDestinationSummaries",
      suppressedDestinationSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse
  ) extends zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly {
    override val suppressedDestinationSummaries: Option[
      List[zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly]
    ] = scala
      .Option(impl.suppressedDestinationSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.SuppressedDestinationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse
  ): zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly =
    new Wrapper(impl)
}
