package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ImportDestination(
    suppressionListDestination: Option[
      zio.aws.sesv2.model.SuppressionListDestination
    ] = None,
    contactListDestination: Option[zio.aws.sesv2.model.ContactListDestination] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ImportDestination = {
    import ImportDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ImportDestination
      .builder()
      .optionallyWith(
        suppressionListDestination.map(value => value.buildAwsValue())
      )(_.suppressionListDestination)
      .optionallyWith(
        contactListDestination.map(value => value.buildAwsValue())
      )(_.contactListDestination)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ImportDestination.ReadOnly =
    zio.aws.sesv2.model.ImportDestination.wrap(buildAwsValue())
}
object ImportDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ImportDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ImportDestination =
      zio.aws.sesv2.model.ImportDestination(
        suppressionListDestination.map(value => value.asEditable),
        contactListDestination.map(value => value.asEditable)
      )
    def suppressionListDestination
        : Option[zio.aws.sesv2.model.SuppressionListDestination.ReadOnly]
    def contactListDestination
        : Option[zio.aws.sesv2.model.ContactListDestination.ReadOnly]
    def getSuppressionListDestination: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.SuppressionListDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "suppressionListDestination",
      suppressionListDestination
    )
    def getContactListDestination: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.ContactListDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "contactListDestination",
      contactListDestination
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ImportDestination
  ) extends zio.aws.sesv2.model.ImportDestination.ReadOnly {
    override val suppressionListDestination
        : Option[zio.aws.sesv2.model.SuppressionListDestination.ReadOnly] =
      scala
        .Option(impl.suppressionListDestination())
        .map(value =>
          zio.aws.sesv2.model.SuppressionListDestination.wrap(value)
        )
    override val contactListDestination
        : Option[zio.aws.sesv2.model.ContactListDestination.ReadOnly] = scala
      .Option(impl.contactListDestination())
      .map(value => zio.aws.sesv2.model.ContactListDestination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ImportDestination
  ): zio.aws.sesv2.model.ImportDestination.ReadOnly = new Wrapper(impl)
}
