package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Enabled, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IdentityInfo(
    identityType: Option[zio.aws.sesv2.model.IdentityType] = None,
    identityName: Option[Identity] = None,
    sendingEnabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.IdentityInfo = {
    import IdentityInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.IdentityInfo
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        identityName.map(value => Identity.unwrap(value): java.lang.String)
      )(_.identityName)
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.IdentityInfo.ReadOnly =
    zio.aws.sesv2.model.IdentityInfo.wrap(buildAwsValue())
}
object IdentityInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.IdentityInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.IdentityInfo =
      zio.aws.sesv2.model.IdentityInfo(
        identityType.map(value => value),
        identityName.map(value => value),
        sendingEnabled.map(value => value)
      )
    def identityType: Option[zio.aws.sesv2.model.IdentityType]
    def identityName: Option[Identity]
    def sendingEnabled: Option[Enabled]
    def getIdentityType: ZIO[Any, AwsError, zio.aws.sesv2.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getIdentityName: ZIO[Any, AwsError, Identity] =
      AwsError.unwrapOptionField("identityName", identityName)
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.IdentityInfo
  ) extends zio.aws.sesv2.model.IdentityInfo.ReadOnly {
    override val identityType: Option[zio.aws.sesv2.model.IdentityType] = scala
      .Option(impl.identityType())
      .map(value => zio.aws.sesv2.model.IdentityType.wrap(value))
    override val identityName: Option[Identity] = scala
      .Option(impl.identityName())
      .map(value => zio.aws.sesv2.model.primitives.Identity(value))
    override val sendingEnabled: Option[Enabled] = scala
      .Option(impl.sendingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.IdentityInfo
  ): zio.aws.sesv2.model.IdentityInfo.ReadOnly = new Wrapper(impl)
}
