package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.MessageContent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDeliverabilityTestReportResponse(
    deliverabilityTestReport: zio.aws.sesv2.model.DeliverabilityTestReport,
    overallPlacement: zio.aws.sesv2.model.PlacementStatistics,
    ispPlacements: Iterable[zio.aws.sesv2.model.IspPlacement],
    message: Option[MessageContent] = None,
    tags: Option[Iterable[zio.aws.sesv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse = {
    import GetDeliverabilityTestReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse
      .builder()
      .deliverabilityTestReport(deliverabilityTestReport.buildAwsValue())
      .overallPlacement(overallPlacement.buildAwsValue())
      .ispPlacements(ispPlacements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        message.map(value => MessageContent.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.GetDeliverabilityTestReportResponse.ReadOnly =
    zio.aws.sesv2.model.GetDeliverabilityTestReportResponse
      .wrap(buildAwsValue())
}
object GetDeliverabilityTestReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetDeliverabilityTestReportResponse =
      zio.aws.sesv2.model.GetDeliverabilityTestReportResponse(
        deliverabilityTestReport.asEditable,
        overallPlacement.asEditable,
        ispPlacements.map { item =>
          item.asEditable
        },
        message.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deliverabilityTestReport
        : zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly
    def overallPlacement: zio.aws.sesv2.model.PlacementStatistics.ReadOnly
    def ispPlacements: List[zio.aws.sesv2.model.IspPlacement.ReadOnly]
    def message: Option[MessageContent]
    def tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def getDeliverabilityTestReport: ZIO[
      Any,
      Nothing,
      zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly
    ] = ZIO.succeed(deliverabilityTestReport)
    def getOverallPlacement
        : ZIO[Any, Nothing, zio.aws.sesv2.model.PlacementStatistics.ReadOnly] =
      ZIO.succeed(overallPlacement)
    def getIspPlacements
        : ZIO[Any, Nothing, List[zio.aws.sesv2.model.IspPlacement.ReadOnly]] =
      ZIO.succeed(ispPlacements)
    def getMessage: ZIO[Any, AwsError, MessageContent] =
      AwsError.unwrapOptionField("message", message)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse
  ) extends zio.aws.sesv2.model.GetDeliverabilityTestReportResponse.ReadOnly {
    override val deliverabilityTestReport
        : zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly =
      zio.aws.sesv2.model.DeliverabilityTestReport
        .wrap(impl.deliverabilityTestReport())
    override val overallPlacement
        : zio.aws.sesv2.model.PlacementStatistics.ReadOnly =
      zio.aws.sesv2.model.PlacementStatistics.wrap(impl.overallPlacement())
    override val ispPlacements
        : List[zio.aws.sesv2.model.IspPlacement.ReadOnly] = impl
      .ispPlacements()
      .asScala
      .map { item =>
        zio.aws.sesv2.model.IspPlacement.wrap(item)
      }
      .toList
    override val message: Option[MessageContent] = scala
      .Option(impl.message())
      .map(value => zio.aws.sesv2.model.primitives.MessageContent(value))
    override val tags: Option[List[zio.aws.sesv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse
  ): zio.aws.sesv2.model.GetDeliverabilityTestReportResponse.ReadOnly =
    new Wrapper(impl)
}
