package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{GeneralEnforcementStatus, Enabled}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAccountResponse(
    dedicatedIpAutoWarmupEnabled: Option[Enabled] = None,
    enforcementStatus: Option[GeneralEnforcementStatus] = None,
    productionAccessEnabled: Option[Enabled] = None,
    sendQuota: Option[zio.aws.sesv2.model.SendQuota] = None,
    sendingEnabled: Option[Enabled] = None,
    suppressionAttributes: Option[zio.aws.sesv2.model.SuppressionAttributes] =
      None,
    details: Option[zio.aws.sesv2.model.AccountDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetAccountResponse = {
    import GetAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetAccountResponse
      .builder()
      .optionallyWith(
        dedicatedIpAutoWarmupEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.dedicatedIpAutoWarmupEnabled)
      .optionallyWith(
        enforcementStatus.map(value =>
          GeneralEnforcementStatus.unwrap(value): java.lang.String
        )
      )(_.enforcementStatus)
      .optionallyWith(
        productionAccessEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.productionAccessEnabled)
      .optionallyWith(sendQuota.map(value => value.buildAwsValue()))(
        _.sendQuota
      )
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .optionallyWith(
        suppressionAttributes.map(value => value.buildAwsValue())
      )(_.suppressionAttributes)
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetAccountResponse.ReadOnly =
    zio.aws.sesv2.model.GetAccountResponse.wrap(buildAwsValue())
}
object GetAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetAccountResponse =
      zio.aws.sesv2.model.GetAccountResponse(
        dedicatedIpAutoWarmupEnabled.map(value => value),
        enforcementStatus.map(value => value),
        productionAccessEnabled.map(value => value),
        sendQuota.map(value => value.asEditable),
        sendingEnabled.map(value => value),
        suppressionAttributes.map(value => value.asEditable),
        details.map(value => value.asEditable)
      )
    def dedicatedIpAutoWarmupEnabled: Option[Enabled]
    def enforcementStatus: Option[GeneralEnforcementStatus]
    def productionAccessEnabled: Option[Enabled]
    def sendQuota: Option[zio.aws.sesv2.model.SendQuota.ReadOnly]
    def sendingEnabled: Option[Enabled]
    def suppressionAttributes
        : Option[zio.aws.sesv2.model.SuppressionAttributes.ReadOnly]
    def details: Option[zio.aws.sesv2.model.AccountDetails.ReadOnly]
    def getDedicatedIpAutoWarmupEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField(
        "dedicatedIpAutoWarmupEnabled",
        dedicatedIpAutoWarmupEnabled
      )
    def getEnforcementStatus: ZIO[Any, AwsError, GeneralEnforcementStatus] =
      AwsError.unwrapOptionField("enforcementStatus", enforcementStatus)
    def getProductionAccessEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("productionAccessEnabled", productionAccessEnabled)
    def getSendQuota
        : ZIO[Any, AwsError, zio.aws.sesv2.model.SendQuota.ReadOnly] =
      AwsError.unwrapOptionField("sendQuota", sendQuota)
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
    def getSuppressionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.SuppressionAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("suppressionAttributes", suppressionAttributes)
    def getDetails
        : ZIO[Any, AwsError, zio.aws.sesv2.model.AccountDetails.ReadOnly] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetAccountResponse
  ) extends zio.aws.sesv2.model.GetAccountResponse.ReadOnly {
    override val dedicatedIpAutoWarmupEnabled: Option[Enabled] = scala
      .Option(impl.dedicatedIpAutoWarmupEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val enforcementStatus: Option[GeneralEnforcementStatus] = scala
      .Option(impl.enforcementStatus())
      .map(value =>
        zio.aws.sesv2.model.primitives.GeneralEnforcementStatus(value)
      )
    override val productionAccessEnabled: Option[Enabled] = scala
      .Option(impl.productionAccessEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val sendQuota: Option[zio.aws.sesv2.model.SendQuota.ReadOnly] =
      scala
        .Option(impl.sendQuota())
        .map(value => zio.aws.sesv2.model.SendQuota.wrap(value))
    override val sendingEnabled: Option[Enabled] = scala
      .Option(impl.sendingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val suppressionAttributes
        : Option[zio.aws.sesv2.model.SuppressionAttributes.ReadOnly] = scala
      .Option(impl.suppressionAttributes())
      .map(value => zio.aws.sesv2.model.SuppressionAttributes.wrap(value))
    override val details: Option[zio.aws.sesv2.model.AccountDetails.ReadOnly] =
      scala
        .Option(impl.details())
        .map(value => zio.aws.sesv2.model.AccountDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetAccountResponse
  ): zio.aws.sesv2.model.GetAccountResponse.ReadOnly = new Wrapper(impl)
}
