package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Enabled
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EventDestinationDefinition(
    enabled: Option[Enabled] = None,
    matchingEventTypes: Option[Iterable[zio.aws.sesv2.model.EventType]] = None,
    kinesisFirehoseDestination: Option[
      zio.aws.sesv2.model.KinesisFirehoseDestination
    ] = None,
    cloudWatchDestination: Option[zio.aws.sesv2.model.CloudWatchDestination] =
      None,
    snsDestination: Option[zio.aws.sesv2.model.SnsDestination] = None,
    pinpointDestination: Option[zio.aws.sesv2.model.PinpointDestination] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.EventDestinationDefinition = {
    import EventDestinationDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.EventDestinationDefinition
      .builder()
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        matchingEventTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.matchingEventTypesWithStrings)
      .optionallyWith(
        kinesisFirehoseDestination.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseDestination)
      .optionallyWith(
        cloudWatchDestination.map(value => value.buildAwsValue())
      )(_.cloudWatchDestination)
      .optionallyWith(snsDestination.map(value => value.buildAwsValue()))(
        _.snsDestination
      )
      .optionallyWith(pinpointDestination.map(value => value.buildAwsValue()))(
        _.pinpointDestination
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.EventDestinationDefinition.ReadOnly =
    zio.aws.sesv2.model.EventDestinationDefinition.wrap(buildAwsValue())
}
object EventDestinationDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.EventDestinationDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.EventDestinationDefinition =
      zio.aws.sesv2.model.EventDestinationDefinition(
        enabled.map(value => value),
        matchingEventTypes.map(value => value),
        kinesisFirehoseDestination.map(value => value.asEditable),
        cloudWatchDestination.map(value => value.asEditable),
        snsDestination.map(value => value.asEditable),
        pinpointDestination.map(value => value.asEditable)
      )
    def enabled: Option[Enabled]
    def matchingEventTypes: Option[List[zio.aws.sesv2.model.EventType]]
    def kinesisFirehoseDestination
        : Option[zio.aws.sesv2.model.KinesisFirehoseDestination.ReadOnly]
    def cloudWatchDestination
        : Option[zio.aws.sesv2.model.CloudWatchDestination.ReadOnly]
    def snsDestination: Option[zio.aws.sesv2.model.SnsDestination.ReadOnly]
    def pinpointDestination
        : Option[zio.aws.sesv2.model.PinpointDestination.ReadOnly]
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getMatchingEventTypes
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.EventType]] =
      AwsError.unwrapOptionField("matchingEventTypes", matchingEventTypes)
    def getKinesisFirehoseDestination: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.KinesisFirehoseDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseDestination",
      kinesisFirehoseDestination
    )
    def getCloudWatchDestination: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.CloudWatchDestination.ReadOnly
    ] =
      AwsError.unwrapOptionField("cloudWatchDestination", cloudWatchDestination)
    def getSnsDestination
        : ZIO[Any, AwsError, zio.aws.sesv2.model.SnsDestination.ReadOnly] =
      AwsError.unwrapOptionField("snsDestination", snsDestination)
    def getPinpointDestination
        : ZIO[Any, AwsError, zio.aws.sesv2.model.PinpointDestination.ReadOnly] =
      AwsError.unwrapOptionField("pinpointDestination", pinpointDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.EventDestinationDefinition
  ) extends zio.aws.sesv2.model.EventDestinationDefinition.ReadOnly {
    override val enabled: Option[Enabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val matchingEventTypes
        : Option[List[zio.aws.sesv2.model.EventType]] = scala
      .Option(impl.matchingEventTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.EventType.wrap(item)
        }.toList
      )
    override val kinesisFirehoseDestination
        : Option[zio.aws.sesv2.model.KinesisFirehoseDestination.ReadOnly] =
      scala
        .Option(impl.kinesisFirehoseDestination())
        .map(value =>
          zio.aws.sesv2.model.KinesisFirehoseDestination.wrap(value)
        )
    override val cloudWatchDestination
        : Option[zio.aws.sesv2.model.CloudWatchDestination.ReadOnly] = scala
      .Option(impl.cloudWatchDestination())
      .map(value => zio.aws.sesv2.model.CloudWatchDestination.wrap(value))
    override val snsDestination
        : Option[zio.aws.sesv2.model.SnsDestination.ReadOnly] = scala
      .Option(impl.snsDestination())
      .map(value => zio.aws.sesv2.model.SnsDestination.wrap(value))
    override val pinpointDestination
        : Option[zio.aws.sesv2.model.PinpointDestination.ReadOnly] = scala
      .Option(impl.pinpointDestination())
      .map(value => zio.aws.sesv2.model.PinpointDestination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.EventDestinationDefinition
  ): zio.aws.sesv2.model.EventDestinationDefinition.ReadOnly = new Wrapper(impl)
}
