package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{OutboundMessageId, ErrorMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BulkEmailEntryResult(
    status: Option[zio.aws.sesv2.model.BulkEmailStatus] = None,
    error: Option[ErrorMessage] = None,
    messageId: Option[OutboundMessageId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.BulkEmailEntryResult = {
    import BulkEmailEntryResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.BulkEmailEntryResult
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        error.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(
        messageId.map(value =>
          OutboundMessageId.unwrap(value): java.lang.String
        )
      )(_.messageId)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.BulkEmailEntryResult.ReadOnly =
    zio.aws.sesv2.model.BulkEmailEntryResult.wrap(buildAwsValue())
}
object BulkEmailEntryResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.BulkEmailEntryResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.BulkEmailEntryResult =
      zio.aws.sesv2.model.BulkEmailEntryResult(
        status.map(value => value),
        error.map(value => value),
        messageId.map(value => value)
      )
    def status: Option[zio.aws.sesv2.model.BulkEmailStatus]
    def error: Option[ErrorMessage]
    def messageId: Option[OutboundMessageId]
    def getStatus: ZIO[Any, AwsError, zio.aws.sesv2.model.BulkEmailStatus] =
      AwsError.unwrapOptionField("status", status)
    def getError: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("error", error)
    def getMessageId: ZIO[Any, AwsError, OutboundMessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.BulkEmailEntryResult
  ) extends zio.aws.sesv2.model.BulkEmailEntryResult.ReadOnly {
    override val status: Option[zio.aws.sesv2.model.BulkEmailStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.sesv2.model.BulkEmailStatus.wrap(value))
    override val error: Option[ErrorMessage] = scala
      .Option(impl.error())
      .map(value => zio.aws.sesv2.model.primitives.ErrorMessage(value))
    override val messageId: Option[OutboundMessageId] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.sesv2.model.primitives.OutboundMessageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.BulkEmailEntryResult
  ): zio.aws.sesv2.model.BulkEmailEntryResult.ReadOnly = new Wrapper(impl)
}
