package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BulkEmailContent(
    template: Option[zio.aws.sesv2.model.Template] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.BulkEmailContent = {
    import BulkEmailContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.BulkEmailContent
      .builder()
      .optionallyWith(template.map(value => value.buildAwsValue()))(_.template)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.BulkEmailContent.ReadOnly =
    zio.aws.sesv2.model.BulkEmailContent.wrap(buildAwsValue())
}
object BulkEmailContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.BulkEmailContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.BulkEmailContent = zio.aws.sesv2.model
      .BulkEmailContent(template.map(value => value.asEditable))
    def template: Option[zio.aws.sesv2.model.Template.ReadOnly]
    def getTemplate: ZIO[Any, AwsError, zio.aws.sesv2.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("template", template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.BulkEmailContent
  ) extends zio.aws.sesv2.model.BulkEmailContent.ReadOnly {
    override val template: Option[zio.aws.sesv2.model.Template.ReadOnly] = scala
      .Option(impl.template())
      .map(value => zio.aws.sesv2.model.Template.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.BulkEmailContent
  ): zio.aws.sesv2.model.BulkEmailContent.ReadOnly = new Wrapper(impl)
}
