package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.EmailTemplateData
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReplacementTemplate(
    replacementTemplateData: Option[EmailTemplateData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ReplacementTemplate = {
    import ReplacementTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ReplacementTemplate
      .builder()
      .optionallyWith(
        replacementTemplateData.map(value =>
          EmailTemplateData.unwrap(value): java.lang.String
        )
      )(_.replacementTemplateData)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ReplacementTemplate.ReadOnly =
    zio.aws.sesv2.model.ReplacementTemplate.wrap(buildAwsValue())
}
object ReplacementTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ReplacementTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ReplacementTemplate =
      zio.aws.sesv2.model
        .ReplacementTemplate(replacementTemplateData.map(value => value))
    def replacementTemplateData: Option[EmailTemplateData]
    def getReplacementTemplateData: ZIO[Any, AwsError, EmailTemplateData] =
      AwsError.unwrapOptionField(
        "replacementTemplateData",
        replacementTemplateData
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ReplacementTemplate
  ) extends zio.aws.sesv2.model.ReplacementTemplate.ReadOnly {
    override val replacementTemplateData: Option[EmailTemplateData] = scala
      .Option(impl.replacementTemplateData())
      .map(value => zio.aws.sesv2.model.primitives.EmailTemplateData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ReplacementTemplate
  ): zio.aws.sesv2.model.ReplacementTemplate.ReadOnly = new Wrapper(impl)
}
