package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Enabled, ConfigurationSetName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutConfigurationSetReputationOptionsRequest(
    configurationSetName: ConfigurationSetName,
    reputationMetricsEnabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest = {
    import PutConfigurationSetReputationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(
        reputationMetricsEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.reputationMetricsEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutConfigurationSetReputationOptionsRequest.ReadOnly =
    zio.aws.sesv2.model.PutConfigurationSetReputationOptionsRequest
      .wrap(buildAwsValue())
}
object PutConfigurationSetReputationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutConfigurationSetReputationOptionsRequest =
      zio.aws.sesv2.model.PutConfigurationSetReputationOptionsRequest(
        configurationSetName,
        reputationMetricsEnabled.map(value => value)
      )
    def configurationSetName: ConfigurationSetName
    def reputationMetricsEnabled: Option[Enabled]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getReputationMetricsEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("reputationMetricsEnabled", reputationMetricsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest
  ) extends zio.aws.sesv2.model.PutConfigurationSetReputationOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val reputationMetricsEnabled: Option[Enabled] = scala
      .Option(impl.reputationMetricsEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest
  ): zio.aws.sesv2.model.PutConfigurationSetReputationOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
