package zio.aws.sesv2.model
import java.lang.Integer
import zio.aws.sesv2.model.primitives.{MaxItems, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListConfigurationSetsRequest(
    nextToken: Option[NextToken] = None,
    pageSize: Option[MaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest = {
    import ListConfigurationSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListConfigurationSetsRequest.ReadOnly =
    zio.aws.sesv2.model.ListConfigurationSetsRequest.wrap(buildAwsValue())
}
object ListConfigurationSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListConfigurationSetsRequest =
      zio.aws.sesv2.model.ListConfigurationSetsRequest(
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def nextToken: Option[NextToken]
    def pageSize: Option[MaxItems]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest
  ) extends zio.aws.sesv2.model.ListConfigurationSetsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
    override val pageSize: Option[MaxItems] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.sesv2.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest
  ): zio.aws.sesv2.model.ListConfigurationSetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
