package zio.aws.sesv2.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{
  FailedRecordsCount,
  ProcessedRecordsCount,
  Timestamp,
  JobId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetImportJobResponse(
    jobId: Option[JobId] = None,
    importDestination: Option[zio.aws.sesv2.model.ImportDestination] = None,
    importDataSource: Option[zio.aws.sesv2.model.ImportDataSource] = None,
    failureInfo: Option[zio.aws.sesv2.model.FailureInfo] = None,
    jobStatus: Option[zio.aws.sesv2.model.JobStatus] = None,
    createdTimestamp: Option[Timestamp] = None,
    completedTimestamp: Option[Timestamp] = None,
    processedRecordsCount: Option[ProcessedRecordsCount] = None,
    failedRecordsCount: Option[FailedRecordsCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetImportJobResponse = {
    import GetImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetImportJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(importDestination.map(value => value.buildAwsValue()))(
        _.importDestination
      )
      .optionallyWith(importDataSource.map(value => value.buildAwsValue()))(
        _.importDataSource
      )
      .optionallyWith(failureInfo.map(value => value.buildAwsValue()))(
        _.failureInfo
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        completedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.completedTimestamp)
      .optionallyWith(
        processedRecordsCount.map(value =>
          ProcessedRecordsCount.unwrap(value): Integer
        )
      )(_.processedRecordsCount)
      .optionallyWith(
        failedRecordsCount.map(value =>
          FailedRecordsCount.unwrap(value): Integer
        )
      )(_.failedRecordsCount)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetImportJobResponse.ReadOnly =
    zio.aws.sesv2.model.GetImportJobResponse.wrap(buildAwsValue())
}
object GetImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetImportJobResponse =
      zio.aws.sesv2.model.GetImportJobResponse(
        jobId.map(value => value),
        importDestination.map(value => value.asEditable),
        importDataSource.map(value => value.asEditable),
        failureInfo.map(value => value.asEditable),
        jobStatus.map(value => value),
        createdTimestamp.map(value => value),
        completedTimestamp.map(value => value),
        processedRecordsCount.map(value => value),
        failedRecordsCount.map(value => value)
      )
    def jobId: Option[JobId]
    def importDestination
        : Option[zio.aws.sesv2.model.ImportDestination.ReadOnly]
    def importDataSource: Option[zio.aws.sesv2.model.ImportDataSource.ReadOnly]
    def failureInfo: Option[zio.aws.sesv2.model.FailureInfo.ReadOnly]
    def jobStatus: Option[zio.aws.sesv2.model.JobStatus]
    def createdTimestamp: Option[Timestamp]
    def completedTimestamp: Option[Timestamp]
    def processedRecordsCount: Option[ProcessedRecordsCount]
    def failedRecordsCount: Option[FailedRecordsCount]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getImportDestination
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ImportDestination.ReadOnly] =
      AwsError.unwrapOptionField("importDestination", importDestination)
    def getImportDataSource
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ImportDataSource.ReadOnly] =
      AwsError.unwrapOptionField("importDataSource", importDataSource)
    def getFailureInfo
        : ZIO[Any, AwsError, zio.aws.sesv2.model.FailureInfo.ReadOnly] =
      AwsError.unwrapOptionField("failureInfo", failureInfo)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.sesv2.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getCompletedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completedTimestamp", completedTimestamp)
    def getProcessedRecordsCount: ZIO[Any, AwsError, ProcessedRecordsCount] =
      AwsError.unwrapOptionField("processedRecordsCount", processedRecordsCount)
    def getFailedRecordsCount: ZIO[Any, AwsError, FailedRecordsCount] =
      AwsError.unwrapOptionField("failedRecordsCount", failedRecordsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetImportJobResponse
  ) extends zio.aws.sesv2.model.GetImportJobResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.sesv2.model.primitives.JobId(value))
    override val importDestination
        : Option[zio.aws.sesv2.model.ImportDestination.ReadOnly] = scala
      .Option(impl.importDestination())
      .map(value => zio.aws.sesv2.model.ImportDestination.wrap(value))
    override val importDataSource
        : Option[zio.aws.sesv2.model.ImportDataSource.ReadOnly] = scala
      .Option(impl.importDataSource())
      .map(value => zio.aws.sesv2.model.ImportDataSource.wrap(value))
    override val failureInfo: Option[zio.aws.sesv2.model.FailureInfo.ReadOnly] =
      scala
        .Option(impl.failureInfo())
        .map(value => zio.aws.sesv2.model.FailureInfo.wrap(value))
    override val jobStatus: Option[zio.aws.sesv2.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.sesv2.model.JobStatus.wrap(value))
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val completedTimestamp: Option[Timestamp] = scala
      .Option(impl.completedTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val processedRecordsCount: Option[ProcessedRecordsCount] = scala
      .Option(impl.processedRecordsCount())
      .map(value => zio.aws.sesv2.model.primitives.ProcessedRecordsCount(value))
    override val failedRecordsCount: Option[FailedRecordsCount] = scala
      .Option(impl.failedRecordsCount())
      .map(value => zio.aws.sesv2.model.primitives.FailedRecordsCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetImportJobResponse
  ): zio.aws.sesv2.model.GetImportJobResponse.ReadOnly = new Wrapper(impl)
}
