package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  EmailAddress,
  AttributesData,
  UnsubscribeAll,
  ContactListName,
  Timestamp
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetContactResponse(
    contactListName: Option[ContactListName] = None,
    emailAddress: Option[EmailAddress] = None,
    topicPreferences: Option[Iterable[zio.aws.sesv2.model.TopicPreference]] =
      None,
    topicDefaultPreferences: Option[
      Iterable[zio.aws.sesv2.model.TopicPreference]
    ] = None,
    unsubscribeAll: Option[UnsubscribeAll] = None,
    attributesData: Option[AttributesData] = None,
    createdTimestamp: Option[Timestamp] = None,
    lastUpdatedTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetContactResponse = {
    import GetContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetContactResponse
      .builder()
      .optionallyWith(
        contactListName.map(value =>
          ContactListName.unwrap(value): java.lang.String
        )
      )(_.contactListName)
      .optionallyWith(
        emailAddress.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        topicPreferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicPreferences)
      .optionallyWith(
        topicDefaultPreferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicDefaultPreferences)
      .optionallyWith(
        unsubscribeAll.map(value =>
          UnsubscribeAll.unwrap(value): java.lang.Boolean
        )
      )(_.unsubscribeAll)
      .optionallyWith(
        attributesData.map(value =>
          AttributesData.unwrap(value): java.lang.String
        )
      )(_.attributesData)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetContactResponse.ReadOnly =
    zio.aws.sesv2.model.GetContactResponse.wrap(buildAwsValue())
}
object GetContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetContactResponse =
      zio.aws.sesv2.model.GetContactResponse(
        contactListName.map(value => value),
        emailAddress.map(value => value),
        topicPreferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        topicDefaultPreferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsubscribeAll.map(value => value),
        attributesData.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def contactListName: Option[ContactListName]
    def emailAddress: Option[EmailAddress]
    def topicPreferences
        : Option[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]]
    def topicDefaultPreferences
        : Option[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]]
    def unsubscribeAll: Option[UnsubscribeAll]
    def attributesData: Option[AttributesData]
    def createdTimestamp: Option[Timestamp]
    def lastUpdatedTimestamp: Option[Timestamp]
    def getContactListName: ZIO[Any, AwsError, ContactListName] =
      AwsError.unwrapOptionField("contactListName", contactListName)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getTopicPreferences: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.TopicPreference.ReadOnly
    ]] = AwsError.unwrapOptionField("topicPreferences", topicPreferences)
    def getTopicDefaultPreferences: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.TopicPreference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "topicDefaultPreferences",
      topicDefaultPreferences
    )
    def getUnsubscribeAll: ZIO[Any, AwsError, UnsubscribeAll] =
      AwsError.unwrapOptionField("unsubscribeAll", unsubscribeAll)
    def getAttributesData: ZIO[Any, AwsError, AttributesData] =
      AwsError.unwrapOptionField("attributesData", attributesData)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetContactResponse
  ) extends zio.aws.sesv2.model.GetContactResponse.ReadOnly {
    override val contactListName: Option[ContactListName] = scala
      .Option(impl.contactListName())
      .map(value => zio.aws.sesv2.model.primitives.ContactListName(value))
    override val emailAddress: Option[EmailAddress] = scala
      .Option(impl.emailAddress())
      .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val topicPreferences
        : Option[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]] = scala
      .Option(impl.topicPreferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.TopicPreference.wrap(item)
        }.toList
      )
    override val topicDefaultPreferences
        : Option[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]] = scala
      .Option(impl.topicDefaultPreferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.TopicPreference.wrap(item)
        }.toList
      )
    override val unsubscribeAll: Option[UnsubscribeAll] = scala
      .Option(impl.unsubscribeAll())
      .map(value => zio.aws.sesv2.model.primitives.UnsubscribeAll(value))
    override val attributesData: Option[AttributesData] = scala
      .Option(impl.attributesData())
      .map(value => zio.aws.sesv2.model.primitives.AttributesData(value))
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetContactResponse
  ): zio.aws.sesv2.model.GetContactResponse.ReadOnly = new Wrapper(impl)
}
