package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Timestamp, Domain}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DomainDeliverabilityTrackingOption(
    domain: Option[Domain] = None,
    subscriptionStartDate: Option[Timestamp] = None,
    inboxPlacementTrackingOption: Option[
      zio.aws.sesv2.model.InboxPlacementTrackingOption
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption = {
    import DomainDeliverabilityTrackingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption
      .builder()
      .optionallyWith(
        domain.map(value => Domain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        subscriptionStartDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.subscriptionStartDate)
      .optionallyWith(
        inboxPlacementTrackingOption.map(value => value.buildAwsValue())
      )(_.inboxPlacementTrackingOption)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly =
    zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.wrap(buildAwsValue())
}
object DomainDeliverabilityTrackingOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DomainDeliverabilityTrackingOption =
      zio.aws.sesv2.model.DomainDeliverabilityTrackingOption(
        domain.map(value => value),
        subscriptionStartDate.map(value => value),
        inboxPlacementTrackingOption.map(value => value.asEditable)
      )
    def domain: Option[Domain]
    def subscriptionStartDate: Option[Timestamp]
    def inboxPlacementTrackingOption
        : Option[zio.aws.sesv2.model.InboxPlacementTrackingOption.ReadOnly]
    def getDomain: ZIO[Any, AwsError, Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getSubscriptionStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("subscriptionStartDate", subscriptionStartDate)
    def getInboxPlacementTrackingOption: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.InboxPlacementTrackingOption.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inboxPlacementTrackingOption",
      inboxPlacementTrackingOption
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption
  ) extends zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly {
    override val domain: Option[Domain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.sesv2.model.primitives.Domain(value))
    override val subscriptionStartDate: Option[Timestamp] = scala
      .Option(impl.subscriptionStartDate())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val inboxPlacementTrackingOption
        : Option[zio.aws.sesv2.model.InboxPlacementTrackingOption.ReadOnly] =
      scala
        .Option(impl.inboxPlacementTrackingOption())
        .map(value =>
          zio.aws.sesv2.model.InboxPlacementTrackingOption.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption
  ): zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly =
    new Wrapper(impl)
}
