package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  EmailTemplateName,
  EmailAddress,
  EmailTemplateSubject,
  FailureRedirectionURL,
  SuccessRedirectionURL
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CustomVerificationEmailTemplateMetadata(
    templateName: Option[EmailTemplateName] = None,
    fromEmailAddress: Option[EmailAddress] = None,
    templateSubject: Option[EmailTemplateSubject] = None,
    successRedirectionURL: Option[SuccessRedirectionURL] = None,
    failureRedirectionURL: Option[FailureRedirectionURL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CustomVerificationEmailTemplateMetadata = {
    import CustomVerificationEmailTemplateMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CustomVerificationEmailTemplateMetadata
      .builder()
      .optionallyWith(
        templateName.map(value =>
          EmailTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        fromEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        templateSubject.map(value =>
          EmailTemplateSubject.unwrap(value): java.lang.String
        )
      )(_.templateSubject)
      .optionallyWith(
        successRedirectionURL.map(value =>
          SuccessRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.successRedirectionURL)
      .optionallyWith(
        failureRedirectionURL.map(value =>
          FailureRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.failureRedirectionURL)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly =
    zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata
      .wrap(buildAwsValue())
}
object CustomVerificationEmailTemplateMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CustomVerificationEmailTemplateMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata =
      zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata(
        templateName.map(value => value),
        fromEmailAddress.map(value => value),
        templateSubject.map(value => value),
        successRedirectionURL.map(value => value),
        failureRedirectionURL.map(value => value)
      )
    def templateName: Option[EmailTemplateName]
    def fromEmailAddress: Option[EmailAddress]
    def templateSubject: Option[EmailTemplateSubject]
    def successRedirectionURL: Option[SuccessRedirectionURL]
    def failureRedirectionURL: Option[FailureRedirectionURL]
    def getTemplateName: ZIO[Any, AwsError, EmailTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getFromEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getTemplateSubject: ZIO[Any, AwsError, EmailTemplateSubject] =
      AwsError.unwrapOptionField("templateSubject", templateSubject)
    def getSuccessRedirectionURL: ZIO[Any, AwsError, SuccessRedirectionURL] =
      AwsError.unwrapOptionField("successRedirectionURL", successRedirectionURL)
    def getFailureRedirectionURL: ZIO[Any, AwsError, FailureRedirectionURL] =
      AwsError.unwrapOptionField("failureRedirectionURL", failureRedirectionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CustomVerificationEmailTemplateMetadata
  ) extends zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly {
    override val templateName: Option[EmailTemplateName] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.sesv2.model.primitives.EmailTemplateName(value))
    override val fromEmailAddress: Option[EmailAddress] = scala
      .Option(impl.fromEmailAddress())
      .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val templateSubject: Option[EmailTemplateSubject] = scala
      .Option(impl.templateSubject())
      .map(value => zio.aws.sesv2.model.primitives.EmailTemplateSubject(value))
    override val successRedirectionURL: Option[SuccessRedirectionURL] = scala
      .Option(impl.successRedirectionURL())
      .map(value => zio.aws.sesv2.model.primitives.SuccessRedirectionURL(value))
    override val failureRedirectionURL: Option[FailureRedirectionURL] = scala
      .Option(impl.failureRedirectionURL())
      .map(value => zio.aws.sesv2.model.primitives.FailureRedirectionURL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CustomVerificationEmailTemplateMetadata
  ): zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly =
    new Wrapper(impl)
}
