package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{DefaultDimensionValue, DimensionName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CloudWatchDimensionConfiguration(
    dimensionName: DimensionName,
    dimensionValueSource: zio.aws.sesv2.model.DimensionValueSource,
    defaultDimensionValue: DefaultDimensionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CloudWatchDimensionConfiguration = {
    import CloudWatchDimensionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CloudWatchDimensionConfiguration
      .builder()
      .dimensionName(DimensionName.unwrap(dimensionName): java.lang.String)
      .dimensionValueSource(dimensionValueSource.unwrap)
      .defaultDimensionValue(
        DefaultDimensionValue.unwrap(defaultDimensionValue): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.CloudWatchDimensionConfiguration.ReadOnly =
    zio.aws.sesv2.model.CloudWatchDimensionConfiguration.wrap(buildAwsValue())
}
object CloudWatchDimensionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CloudWatchDimensionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CloudWatchDimensionConfiguration =
      zio.aws.sesv2.model.CloudWatchDimensionConfiguration(
        dimensionName,
        dimensionValueSource,
        defaultDimensionValue
      )
    def dimensionName: DimensionName
    def dimensionValueSource: zio.aws.sesv2.model.DimensionValueSource
    def defaultDimensionValue: DefaultDimensionValue
    def getDimensionName: ZIO[Any, Nothing, DimensionName] =
      ZIO.succeed(dimensionName)
    def getDimensionValueSource
        : ZIO[Any, Nothing, zio.aws.sesv2.model.DimensionValueSource] =
      ZIO.succeed(dimensionValueSource)
    def getDefaultDimensionValue: ZIO[Any, Nothing, DefaultDimensionValue] =
      ZIO.succeed(defaultDimensionValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CloudWatchDimensionConfiguration
  ) extends zio.aws.sesv2.model.CloudWatchDimensionConfiguration.ReadOnly {
    override val dimensionName: DimensionName =
      zio.aws.sesv2.model.primitives.DimensionName(impl.dimensionName())
    override val dimensionValueSource
        : zio.aws.sesv2.model.DimensionValueSource =
      zio.aws.sesv2.model.DimensionValueSource.wrap(impl.dimensionValueSource())
    override val defaultDimensionValue: DefaultDimensionValue =
      zio.aws.sesv2.model.primitives
        .DefaultDimensionValue(impl.defaultDimensionValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CloudWatchDimensionConfiguration
  ): zio.aws.sesv2.model.CloudWatchDimensionConfiguration.ReadOnly =
    new Wrapper(impl)
}
