package zio.aws.servicequotas
import zio.aws.servicequotas.model.primitives.{
  MetricDimensionValue,
  MetricDimensionName,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.servicequotas.model.primitives.QuotaName.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.servicequotas.model.primitives.AmazonResourceName.Type
    object AwsRegion extends Subtype[String]
    type AwsRegion = zio.aws.servicequotas.model.primitives.AwsRegion.Type
    object CustomerServiceEngagementId extends Subtype[String]
    type CustomerServiceEngagementId =
      zio.aws.servicequotas.model.primitives.CustomerServiceEngagementId.Type
    object DateTime extends Subtype[Instant]
    type DateTime = zio.aws.servicequotas.model.primitives.DateTime.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.servicequotas.model.primitives.ErrorMessage.Type
    object GlobalQuota extends Subtype[Boolean]
    type GlobalQuota = zio.aws.servicequotas.model.primitives.GlobalQuota.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.servicequotas.model.primitives.MaxResults.Type
    object MetricDimensionName extends Subtype[String]
    type MetricDimensionName =
      zio.aws.servicequotas.model.primitives.MetricDimensionName.Type
    object MetricDimensionValue extends Subtype[String]
    type MetricDimensionValue =
      zio.aws.servicequotas.model.primitives.MetricDimensionValue.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.servicequotas.model.primitives.NextToken.Type
    object PeriodValue extends Subtype[Int]
    type PeriodValue = zio.aws.servicequotas.model.primitives.PeriodValue.Type
    object QuotaAdjustable extends Subtype[Boolean]
    type QuotaAdjustable =
      zio.aws.servicequotas.model.primitives.QuotaAdjustable.Type
    object QuotaArn extends Subtype[String]
    type QuotaArn = zio.aws.servicequotas.model.primitives.QuotaArn.Type
    object QuotaCode extends Subtype[String]
    type QuotaCode = zio.aws.servicequotas.model.primitives.QuotaCode.Type
    object QuotaContextId extends Subtype[String]
    type QuotaContextId =
      zio.aws.servicequotas.model.primitives.QuotaContextId.Type
    object QuotaContextScopeType extends Subtype[String]
    type QuotaContextScopeType =
      zio.aws.servicequotas.model.primitives.QuotaContextScopeType.Type
    object QuotaMetricName extends Subtype[String]
    type QuotaMetricName =
      zio.aws.servicequotas.model.primitives.QuotaMetricName.Type
    object QuotaMetricNamespace extends Subtype[String]
    type QuotaMetricNamespace =
      zio.aws.servicequotas.model.primitives.QuotaMetricNamespace.Type
    object QuotaName extends Subtype[String]
    type QuotaName = zio.aws.servicequotas.model.primitives.QuotaName.Type
    object QuotaUnit extends Subtype[String]
    type QuotaUnit = zio.aws.servicequotas.model.primitives.QuotaUnit.Type
    object QuotaValue extends Subtype[Double]
    type QuotaValue = zio.aws.servicequotas.model.primitives.QuotaValue.Type
    object RequestId extends Subtype[String]
    type RequestId = zio.aws.servicequotas.model.primitives.RequestId.Type
    object Requester extends Subtype[String]
    type Requester = zio.aws.servicequotas.model.primitives.Requester.Type
    object ServiceCode extends Subtype[String]
    type ServiceCode = zio.aws.servicequotas.model.primitives.ServiceCode.Type
    object ServiceName extends Subtype[String]
    type ServiceName = zio.aws.servicequotas.model.primitives.ServiceName.Type
    object Statistic extends Subtype[String]
    type Statistic = zio.aws.servicequotas.model.primitives.Statistic.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.servicequotas.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.servicequotas.model.primitives.TagValue.Type
  }
  type InputTagKeys = List[TagKey]
  type InputTags = List[zio.aws.servicequotas.model.Tag]
  type MetricDimensionsMapDefinition =
    Map[MetricDimensionName, MetricDimensionValue]
  type OutputTags = List[zio.aws.servicequotas.model.Tag]
  type RequestedServiceQuotaChangeHistoryListDefinition =
    List[zio.aws.servicequotas.model.RequestedServiceQuotaChange]
  type ServiceInfoListDefinition = List[zio.aws.servicequotas.model.ServiceInfo]
  type ServiceQuotaIncreaseRequestInTemplateList =
    List[zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate]
  type ServiceQuotaListDefinition =
    List[zio.aws.servicequotas.model.ServiceQuota]
}
