package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{ServiceName, ServiceCode}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServiceInfo(
    serviceCode: Optional[ServiceCode] = Optional.Absent,
    serviceName: Optional[ServiceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ServiceInfo = {
    import ServiceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ServiceInfo
      .builder()
      .optionallyWith(
        serviceCode.map(value => ServiceCode.unwrap(value): java.lang.String)
      )(_.serviceCode)
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.ServiceInfo.ReadOnly =
    zio.aws.servicequotas.model.ServiceInfo.wrap(buildAwsValue())
}
object ServiceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ServiceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.ServiceInfo =
      zio.aws.servicequotas.model.ServiceInfo(
        serviceCode.map(value => value),
        serviceName.map(value => value)
      )
    def serviceCode: Optional[ServiceCode]
    def serviceName: Optional[ServiceName]
    def getServiceCode: ZIO[Any, AwsError, ServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ServiceInfo
  ) extends zio.aws.servicequotas.model.ServiceInfo.ReadOnly {
    override val serviceCode: Optional[ServiceCode] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCode())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceCode(value))
    override val serviceName: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ServiceInfo
  ): zio.aws.servicequotas.model.ServiceInfo.ReadOnly = new Wrapper(impl)
}
