package zio.aws.servicequotas.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.servicequotas.model.primitives.{
  CustomerServiceEngagementId,
  QuotaUnit,
  QuotaCode,
  GlobalQuota,
  QuotaArn,
  DateTime,
  ServiceCode,
  RequestId,
  QuotaValue,
  QuotaName,
  ServiceName,
  Requester
}
import scala.jdk.CollectionConverters.*
final case class RequestedServiceQuotaChange(
    id: Optional[RequestId] = Optional.Absent,
    caseId: Optional[CustomerServiceEngagementId] = Optional.Absent,
    serviceCode: Optional[ServiceCode] = Optional.Absent,
    serviceName: Optional[ServiceName] = Optional.Absent,
    quotaCode: Optional[QuotaCode] = Optional.Absent,
    quotaName: Optional[QuotaName] = Optional.Absent,
    desiredValue: Optional[QuotaValue] = Optional.Absent,
    status: Optional[zio.aws.servicequotas.model.RequestStatus] =
      Optional.Absent,
    created: Optional[DateTime] = Optional.Absent,
    lastUpdated: Optional[DateTime] = Optional.Absent,
    requester: Optional[Requester] = Optional.Absent,
    quotaArn: Optional[QuotaArn] = Optional.Absent,
    globalQuota: Optional[GlobalQuota] = Optional.Absent,
    unit: Optional[QuotaUnit] = Optional.Absent,
    quotaRequestedAtLevel: Optional[
      zio.aws.servicequotas.model.AppliedLevelEnum
    ] = Optional.Absent,
    quotaContext: Optional[zio.aws.servicequotas.model.QuotaContextInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange = {
    import RequestedServiceQuotaChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange
      .builder()
      .optionallyWith(
        id.map(value => RequestId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        caseId.map(value =>
          CustomerServiceEngagementId.unwrap(value): java.lang.String
        )
      )(_.caseId)
      .optionallyWith(
        serviceCode.map(value => ServiceCode.unwrap(value): java.lang.String)
      )(_.serviceCode)
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        quotaCode.map(value => QuotaCode.unwrap(value): java.lang.String)
      )(_.quotaCode)
      .optionallyWith(
        quotaName.map(value => QuotaName.unwrap(value): java.lang.String)
      )(_.quotaName)
      .optionallyWith(
        desiredValue.map(value => QuotaValue.unwrap(value): java.lang.Double)
      )(_.desiredValue)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        lastUpdated.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        requester.map(value => Requester.unwrap(value): java.lang.String)
      )(_.requester)
      .optionallyWith(
        quotaArn.map(value => QuotaArn.unwrap(value): java.lang.String)
      )(_.quotaArn)
      .optionallyWith(
        globalQuota.map(value => GlobalQuota.unwrap(value): java.lang.Boolean)
      )(_.globalQuota)
      .optionallyWith(
        unit.map(value => QuotaUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .optionallyWith(quotaRequestedAtLevel.map(value => value.unwrap))(
        _.quotaRequestedAtLevel
      )
      .optionallyWith(quotaContext.map(value => value.buildAwsValue()))(
        _.quotaContext
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly =
    zio.aws.servicequotas.model.RequestedServiceQuotaChange
      .wrap(buildAwsValue())
}
object RequestedServiceQuotaChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.RequestedServiceQuotaChange =
      zio.aws.servicequotas.model.RequestedServiceQuotaChange(
        id.map(value => value),
        caseId.map(value => value),
        serviceCode.map(value => value),
        serviceName.map(value => value),
        quotaCode.map(value => value),
        quotaName.map(value => value),
        desiredValue.map(value => value),
        status.map(value => value),
        created.map(value => value),
        lastUpdated.map(value => value),
        requester.map(value => value),
        quotaArn.map(value => value),
        globalQuota.map(value => value),
        unit.map(value => value),
        quotaRequestedAtLevel.map(value => value),
        quotaContext.map(value => value.asEditable)
      )
    def id: Optional[RequestId]
    def caseId: Optional[CustomerServiceEngagementId]
    def serviceCode: Optional[ServiceCode]
    def serviceName: Optional[ServiceName]
    def quotaCode: Optional[QuotaCode]
    def quotaName: Optional[QuotaName]
    def desiredValue: Optional[QuotaValue]
    def status: Optional[zio.aws.servicequotas.model.RequestStatus]
    def created: Optional[DateTime]
    def lastUpdated: Optional[DateTime]
    def requester: Optional[Requester]
    def quotaArn: Optional[QuotaArn]
    def globalQuota: Optional[GlobalQuota]
    def unit: Optional[QuotaUnit]
    def quotaRequestedAtLevel
        : Optional[zio.aws.servicequotas.model.AppliedLevelEnum]
    def quotaContext
        : Optional[zio.aws.servicequotas.model.QuotaContextInfo.ReadOnly]
    def getId: ZIO[Any, AwsError, RequestId] =
      AwsError.unwrapOptionField("id", id)
    def getCaseId: ZIO[Any, AwsError, CustomerServiceEngagementId] =
      AwsError.unwrapOptionField("caseId", caseId)
    def getServiceCode: ZIO[Any, AwsError, ServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getQuotaCode: ZIO[Any, AwsError, QuotaCode] =
      AwsError.unwrapOptionField("quotaCode", quotaCode)
    def getQuotaName: ZIO[Any, AwsError, QuotaName] =
      AwsError.unwrapOptionField("quotaName", quotaName)
    def getDesiredValue: ZIO[Any, AwsError, QuotaValue] =
      AwsError.unwrapOptionField("desiredValue", desiredValue)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.RequestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getLastUpdated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getRequester: ZIO[Any, AwsError, Requester] =
      AwsError.unwrapOptionField("requester", requester)
    def getQuotaArn: ZIO[Any, AwsError, QuotaArn] =
      AwsError.unwrapOptionField("quotaArn", quotaArn)
    def getGlobalQuota: ZIO[Any, AwsError, GlobalQuota] =
      AwsError.unwrapOptionField("globalQuota", globalQuota)
    def getUnit: ZIO[Any, AwsError, QuotaUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getQuotaRequestedAtLevel
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.AppliedLevelEnum] =
      AwsError.unwrapOptionField("quotaRequestedAtLevel", quotaRequestedAtLevel)
    def getQuotaContext: ZIO[
      Any,
      AwsError,
      zio.aws.servicequotas.model.QuotaContextInfo.ReadOnly
    ] = AwsError.unwrapOptionField("quotaContext", quotaContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange
  ) extends zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly {
    override val id: Optional[RequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.servicequotas.model.primitives.RequestId(value))
    override val caseId: Optional[CustomerServiceEngagementId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caseId())
        .map(value =>
          zio.aws.servicequotas.model.primitives
            .CustomerServiceEngagementId(value)
        )
    override val serviceCode: Optional[ServiceCode] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCode())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceCode(value))
    override val serviceName: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceName(value))
    override val quotaCode: Optional[QuotaCode] = zio.aws.core.internal
      .optionalFromNullable(impl.quotaCode())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaCode(value))
    override val quotaName: Optional[QuotaName] = zio.aws.core.internal
      .optionalFromNullable(impl.quotaName())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaName(value))
    override val desiredValue: Optional[QuotaValue] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredValue())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaValue(value))
    override val status: Optional[zio.aws.servicequotas.model.RequestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.servicequotas.model.RequestStatus.wrap(value))
    override val created: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.servicequotas.model.primitives.DateTime(value))
    override val lastUpdated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.servicequotas.model.primitives.DateTime(value))
    override val requester: Optional[Requester] = zio.aws.core.internal
      .optionalFromNullable(impl.requester())
      .map(value => zio.aws.servicequotas.model.primitives.Requester(value))
    override val quotaArn: Optional[QuotaArn] = zio.aws.core.internal
      .optionalFromNullable(impl.quotaArn())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaArn(value))
    override val globalQuota: Optional[GlobalQuota] = zio.aws.core.internal
      .optionalFromNullable(impl.globalQuota())
      .map(value => zio.aws.servicequotas.model.primitives.GlobalQuota(value))
    override val unit: Optional[QuotaUnit] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaUnit(value))
    override val quotaRequestedAtLevel
        : Optional[zio.aws.servicequotas.model.AppliedLevelEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quotaRequestedAtLevel())
        .map(value => zio.aws.servicequotas.model.AppliedLevelEnum.wrap(value))
    override val quotaContext
        : Optional[zio.aws.servicequotas.model.QuotaContextInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quotaContext())
        .map(value => zio.aws.servicequotas.model.QuotaContextInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange
  ): zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly =
    new Wrapper(impl)
}
