package zio.aws.servicequotas.model
import scala.jdk.CollectionConverters.*
sealed trait RequestStatus {
  def unwrap: software.amazon.awssdk.services.servicequotas.model.RequestStatus
}
object RequestStatus {
  def wrap(
      value: software.amazon.awssdk.services.servicequotas.model.RequestStatus
  ): zio.aws.servicequotas.model.RequestStatus = value match {
    case software.amazon.awssdk.services.servicequotas.model.RequestStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicequotas.model.RequestStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.servicequotas.model.RequestStatus.CASE_OPENED =>
      val r = CASE_OPENED
      r
    case software.amazon.awssdk.services.servicequotas.model.RequestStatus.APPROVED =>
      val r = APPROVED
      r
    case software.amazon.awssdk.services.servicequotas.model.RequestStatus.DENIED =>
      val r = DENIED
      r
    case software.amazon.awssdk.services.servicequotas.model.RequestStatus.CASE_CLOSED =>
      val r = CASE_CLOSED
      r
    case software.amazon.awssdk.services.servicequotas.model.RequestStatus.NOT_APPROVED =>
      val r = NOT_APPROVED
      r
    case software.amazon.awssdk.services.servicequotas.model.RequestStatus.INVALID_REQUEST =>
      val r = INVALID_REQUEST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicequotas.model.RequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.RequestStatus =
      software.amazon.awssdk.services.servicequotas.model.RequestStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.servicequotas.model.RequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.RequestStatus =
      software.amazon.awssdk.services.servicequotas.model.RequestStatus.PENDING
  }
  case object CASE_OPENED extends zio.aws.servicequotas.model.RequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.RequestStatus =
      software.amazon.awssdk.services.servicequotas.model.RequestStatus.CASE_OPENED
  }
  case object APPROVED extends zio.aws.servicequotas.model.RequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.RequestStatus =
      software.amazon.awssdk.services.servicequotas.model.RequestStatus.APPROVED
  }
  case object DENIED extends zio.aws.servicequotas.model.RequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.RequestStatus =
      software.amazon.awssdk.services.servicequotas.model.RequestStatus.DENIED
  }
  case object CASE_CLOSED extends zio.aws.servicequotas.model.RequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.RequestStatus =
      software.amazon.awssdk.services.servicequotas.model.RequestStatus.CASE_CLOSED
  }
  case object NOT_APPROVED extends zio.aws.servicequotas.model.RequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.RequestStatus =
      software.amazon.awssdk.services.servicequotas.model.RequestStatus.NOT_APPROVED
  }
  case object INVALID_REQUEST
      extends zio.aws.servicequotas.model.RequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.RequestStatus =
      software.amazon.awssdk.services.servicequotas.model.RequestStatus.INVALID_REQUEST
  }
}
