package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{
  QuotaContextId,
  QuotaValue,
  QuotaCode,
  ServiceCode
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RequestServiceQuotaIncreaseRequest(
    serviceCode: ServiceCode,
    quotaCode: QuotaCode,
    desiredValue: QuotaValue,
    contextId: Optional[QuotaContextId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest = {
    import RequestServiceQuotaIncreaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest
      .builder()
      .serviceCode(ServiceCode.unwrap(serviceCode): java.lang.String)
      .quotaCode(QuotaCode.unwrap(quotaCode): java.lang.String)
      .desiredValue(QuotaValue.unwrap(desiredValue): java.lang.Double)
      .optionallyWith(
        contextId.map(value => QuotaContextId.unwrap(value): java.lang.String)
      )(_.contextId)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest.ReadOnly =
    zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest
      .wrap(buildAwsValue())
}
object RequestServiceQuotaIncreaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest =
      zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest(
        serviceCode,
        quotaCode,
        desiredValue,
        contextId.map(value => value)
      )
    def serviceCode: ServiceCode
    def quotaCode: QuotaCode
    def desiredValue: QuotaValue
    def contextId: Optional[QuotaContextId]
    def getServiceCode: ZIO[Any, Nothing, ServiceCode] =
      ZIO.succeed(serviceCode)
    def getQuotaCode: ZIO[Any, Nothing, QuotaCode] = ZIO.succeed(quotaCode)
    def getDesiredValue: ZIO[Any, Nothing, QuotaValue] =
      ZIO.succeed(desiredValue)
    def getContextId: ZIO[Any, AwsError, QuotaContextId] =
      AwsError.unwrapOptionField("contextId", contextId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest
  ) extends zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest.ReadOnly {
    override val serviceCode: ServiceCode =
      zio.aws.servicequotas.model.primitives.ServiceCode(impl.serviceCode())
    override val quotaCode: QuotaCode =
      zio.aws.servicequotas.model.primitives.QuotaCode(impl.quotaCode())
    override val desiredValue: QuotaValue =
      zio.aws.servicequotas.model.primitives.QuotaValue(impl.desiredValue())
    override val contextId: Optional[QuotaContextId] = zio.aws.core.internal
      .optionalFromNullable(impl.contextId())
      .map(value =>
        zio.aws.servicequotas.model.primitives.QuotaContextId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest
  ): zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest.ReadOnly =
    new Wrapper(impl)
}
