package zio.aws.servicequotas.model
import scala.jdk.CollectionConverters.*
sealed trait QuotaContextScope {
  def unwrap
      : software.amazon.awssdk.services.servicequotas.model.QuotaContextScope
}
object QuotaContextScope {
  def wrap(
      value: software.amazon.awssdk.services.servicequotas.model.QuotaContextScope
  ): zio.aws.servicequotas.model.QuotaContextScope = value match {
    case software.amazon.awssdk.services.servicequotas.model.QuotaContextScope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicequotas.model.QuotaContextScope.RESOURCE =>
      val r = RESOURCE
      r
    case software.amazon.awssdk.services.servicequotas.model.QuotaContextScope.ACCOUNT =>
      val r = ACCOUNT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicequotas.model.QuotaContextScope {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.QuotaContextScope =
      software.amazon.awssdk.services.servicequotas.model.QuotaContextScope.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOURCE extends zio.aws.servicequotas.model.QuotaContextScope {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.QuotaContextScope =
      software.amazon.awssdk.services.servicequotas.model.QuotaContextScope.RESOURCE
  }
  case object ACCOUNT extends zio.aws.servicequotas.model.QuotaContextScope {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.QuotaContextScope =
      software.amazon.awssdk.services.servicequotas.model.QuotaContextScope.ACCOUNT
  }
}
