package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{
  QuotaContextId,
  QuotaContextScopeType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QuotaContextInfo(
    contextScope: Optional[zio.aws.servicequotas.model.QuotaContextScope] =
      Optional.Absent,
    contextScopeType: Optional[QuotaContextScopeType] = Optional.Absent,
    contextId: Optional[QuotaContextId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.QuotaContextInfo = {
    import QuotaContextInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.QuotaContextInfo
      .builder()
      .optionallyWith(contextScope.map(value => value.unwrap))(_.contextScope)
      .optionallyWith(
        contextScopeType.map(value =>
          QuotaContextScopeType.unwrap(value): java.lang.String
        )
      )(_.contextScopeType)
      .optionallyWith(
        contextId.map(value => QuotaContextId.unwrap(value): java.lang.String)
      )(_.contextId)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.QuotaContextInfo.ReadOnly =
    zio.aws.servicequotas.model.QuotaContextInfo.wrap(buildAwsValue())
}
object QuotaContextInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.QuotaContextInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.QuotaContextInfo =
      zio.aws.servicequotas.model.QuotaContextInfo(
        contextScope.map(value => value),
        contextScopeType.map(value => value),
        contextId.map(value => value)
      )
    def contextScope: Optional[zio.aws.servicequotas.model.QuotaContextScope]
    def contextScopeType: Optional[QuotaContextScopeType]
    def contextId: Optional[QuotaContextId]
    def getContextScope
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.QuotaContextScope] =
      AwsError.unwrapOptionField("contextScope", contextScope)
    def getContextScopeType: ZIO[Any, AwsError, QuotaContextScopeType] =
      AwsError.unwrapOptionField("contextScopeType", contextScopeType)
    def getContextId: ZIO[Any, AwsError, QuotaContextId] =
      AwsError.unwrapOptionField("contextId", contextId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.QuotaContextInfo
  ) extends zio.aws.servicequotas.model.QuotaContextInfo.ReadOnly {
    override val contextScope
        : Optional[zio.aws.servicequotas.model.QuotaContextScope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contextScope())
        .map(value => zio.aws.servicequotas.model.QuotaContextScope.wrap(value))
    override val contextScopeType: Optional[QuotaContextScopeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contextScopeType())
        .map(value =>
          zio.aws.servicequotas.model.primitives.QuotaContextScopeType(value)
        )
    override val contextId: Optional[QuotaContextId] = zio.aws.core.internal
      .optionalFromNullable(impl.contextId())
      .map(value =>
        zio.aws.servicequotas.model.primitives.QuotaContextId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.QuotaContextInfo
  ): zio.aws.servicequotas.model.QuotaContextInfo.ReadOnly = new Wrapper(impl)
}
