package zio.aws.servicequotas.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.servicequotas.model.primitives.{
  QuotaCode,
  MaxResults,
  NextToken,
  ServiceCode
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListServiceQuotasRequest(
    serviceCode: ServiceCode,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    quotaCode: Optional[QuotaCode] = Optional.Absent,
    quotaAppliedAtLevel: Optional[
      zio.aws.servicequotas.model.AppliedLevelEnum
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest = {
    import ListServiceQuotasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest
      .builder()
      .serviceCode(ServiceCode.unwrap(serviceCode): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        quotaCode.map(value => QuotaCode.unwrap(value): java.lang.String)
      )(_.quotaCode)
      .optionallyWith(quotaAppliedAtLevel.map(value => value.unwrap))(
        _.quotaAppliedAtLevel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListServiceQuotasRequest.ReadOnly =
    zio.aws.servicequotas.model.ListServiceQuotasRequest.wrap(buildAwsValue())
}
object ListServiceQuotasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.ListServiceQuotasRequest =
      zio.aws.servicequotas.model.ListServiceQuotasRequest(
        serviceCode,
        nextToken.map(value => value),
        maxResults.map(value => value),
        quotaCode.map(value => value),
        quotaAppliedAtLevel.map(value => value)
      )
    def serviceCode: ServiceCode
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def quotaCode: Optional[QuotaCode]
    def quotaAppliedAtLevel
        : Optional[zio.aws.servicequotas.model.AppliedLevelEnum]
    def getServiceCode: ZIO[Any, Nothing, ServiceCode] =
      ZIO.succeed(serviceCode)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getQuotaCode: ZIO[Any, AwsError, QuotaCode] =
      AwsError.unwrapOptionField("quotaCode", quotaCode)
    def getQuotaAppliedAtLevel
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.AppliedLevelEnum] =
      AwsError.unwrapOptionField("quotaAppliedAtLevel", quotaAppliedAtLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest
  ) extends zio.aws.servicequotas.model.ListServiceQuotasRequest.ReadOnly {
    override val serviceCode: ServiceCode =
      zio.aws.servicequotas.model.primitives.ServiceCode(impl.serviceCode())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.servicequotas.model.primitives.MaxResults(value))
    override val quotaCode: Optional[QuotaCode] = zio.aws.core.internal
      .optionalFromNullable(impl.quotaCode())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaCode(value))
    override val quotaAppliedAtLevel
        : Optional[zio.aws.servicequotas.model.AppliedLevelEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quotaAppliedAtLevel())
        .map(value => zio.aws.servicequotas.model.AppliedLevelEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest
  ): zio.aws.servicequotas.model.ListServiceQuotasRequest.ReadOnly =
    new Wrapper(impl)
}
