package zio.aws.servicequotas.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.servicequotas.model.primitives.{
  MaxResults,
  NextToken,
  ServiceCode
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRequestedServiceQuotaChangeHistoryRequest(
    serviceCode: Optional[ServiceCode] = Optional.Absent,
    status: Optional[zio.aws.servicequotas.model.RequestStatus] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    quotaRequestedAtLevel: Optional[
      zio.aws.servicequotas.model.AppliedLevelEnum
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest = {
    import ListRequestedServiceQuotaChangeHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
      .builder()
      .optionallyWith(
        serviceCode.map(value => ServiceCode.unwrap(value): java.lang.String)
      )(_.serviceCode)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(quotaRequestedAtLevel.map(value => value.unwrap))(
        _.quotaRequestedAtLevel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest.ReadOnly =
    zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
      .wrap(buildAwsValue())
}
object ListRequestedServiceQuotaChangeHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest =
      zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest(
        serviceCode.map(value => value),
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        quotaRequestedAtLevel.map(value => value)
      )
    def serviceCode: Optional[ServiceCode]
    def status: Optional[zio.aws.servicequotas.model.RequestStatus]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def quotaRequestedAtLevel
        : Optional[zio.aws.servicequotas.model.AppliedLevelEnum]
    def getServiceCode: ZIO[Any, AwsError, ServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.RequestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getQuotaRequestedAtLevel
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.AppliedLevelEnum] =
      AwsError.unwrapOptionField("quotaRequestedAtLevel", quotaRequestedAtLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
  ) extends zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest.ReadOnly {
    override val serviceCode: Optional[ServiceCode] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCode())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceCode(value))
    override val status: Optional[zio.aws.servicequotas.model.RequestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.servicequotas.model.RequestStatus.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.servicequotas.model.primitives.MaxResults(value))
    override val quotaRequestedAtLevel
        : Optional[zio.aws.servicequotas.model.AppliedLevelEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quotaRequestedAtLevel())
        .map(value => zio.aws.servicequotas.model.AppliedLevelEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
  ): zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
