package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{
  AwsRegion,
  QuotaCode,
  ServiceCode
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteServiceQuotaIncreaseRequestFromTemplateRequest(
    serviceCode: ServiceCode,
    quotaCode: QuotaCode,
    awsRegion: AwsRegion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest = {
    import DeleteServiceQuotaIncreaseRequestFromTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest
      .builder()
      .serviceCode(ServiceCode.unwrap(serviceCode): java.lang.String)
      .quotaCode(QuotaCode.unwrap(quotaCode): java.lang.String)
      .awsRegion(AwsRegion.unwrap(awsRegion): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest.ReadOnly =
    zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest
      .wrap(buildAwsValue())
}
object DeleteServiceQuotaIncreaseRequestFromTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest =
      zio.aws.servicequotas.model
        .DeleteServiceQuotaIncreaseRequestFromTemplateRequest(
          serviceCode,
          quotaCode,
          awsRegion
        )
    def serviceCode: ServiceCode
    def quotaCode: QuotaCode
    def awsRegion: AwsRegion
    def getServiceCode: ZIO[Any, Nothing, ServiceCode] =
      ZIO.succeed(serviceCode)
    def getQuotaCode: ZIO[Any, Nothing, QuotaCode] = ZIO.succeed(quotaCode)
    def getAwsRegion: ZIO[Any, Nothing, AwsRegion] = ZIO.succeed(awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest
  ) extends zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest.ReadOnly {
    override val serviceCode: ServiceCode =
      zio.aws.servicequotas.model.primitives.ServiceCode(impl.serviceCode())
    override val quotaCode: QuotaCode =
      zio.aws.servicequotas.model.primitives.QuotaCode(impl.quotaCode())
    override val awsRegion: AwsRegion =
      zio.aws.servicequotas.model.primitives.AwsRegion(impl.awsRegion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest
  ): zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
