package zio.aws.servicequotas.model
import scala.jdk.CollectionConverters.*
sealed trait AppliedLevelEnum {
  def unwrap
      : software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum
}
object AppliedLevelEnum {
  def wrap(
      value: software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum
  ): zio.aws.servicequotas.model.AppliedLevelEnum = value match {
    case software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum.ACCOUNT =>
      val r = ACCOUNT
      r
    case software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum.RESOURCE =>
      val r = RESOURCE
      r
    case software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicequotas.model.AppliedLevelEnum {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum =
      software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT extends zio.aws.servicequotas.model.AppliedLevelEnum {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum =
      software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum.ACCOUNT
  }
  case object RESOURCE extends zio.aws.servicequotas.model.AppliedLevelEnum {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum =
      software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum.RESOURCE
  }
  case object ALL extends zio.aws.servicequotas.model.AppliedLevelEnum {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum =
      software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum.ALL
  }
}
