package zio.aws.servicequotas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutServiceQuotaIncreaseRequestIntoTemplateResponse(
    serviceQuotaIncreaseRequestInTemplate: Optional[
      zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse = {
    import PutServiceQuotaIncreaseRequestIntoTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse
      .builder()
      .optionallyWith(
        serviceQuotaIncreaseRequestInTemplate.map(value =>
          value.buildAwsValue()
        )
      )(_.serviceQuotaIncreaseRequestInTemplate)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse.ReadOnly =
    zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse
      .wrap(buildAwsValue())
}
object PutServiceQuotaIncreaseRequestIntoTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse =
      zio.aws.servicequotas.model
        .PutServiceQuotaIncreaseRequestIntoTemplateResponse(
          serviceQuotaIncreaseRequestInTemplate.map(value => value.asEditable)
        )
    def serviceQuotaIncreaseRequestInTemplate: Optional[
      zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
    ]
    def getServiceQuotaIncreaseRequestInTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceQuotaIncreaseRequestInTemplate",
      serviceQuotaIncreaseRequestInTemplate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse
  ) extends zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse.ReadOnly {
    override val serviceQuotaIncreaseRequestInTemplate: Optional[
      zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceQuotaIncreaseRequestInTemplate())
      .map(value =>
        zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse
  ): zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
