package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{
  QuotaMetricName,
  Statistic,
  QuotaMetricNamespace,
  MetricDimensionName,
  MetricDimensionValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MetricInfo(
    metricNamespace: Optional[QuotaMetricNamespace] = Optional.Absent,
    metricName: Optional[QuotaMetricName] = Optional.Absent,
    metricDimensions: Optional[Map[MetricDimensionName, MetricDimensionValue]] =
      Optional.Absent,
    metricStatisticRecommendation: Optional[Statistic] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.MetricInfo = {
    import MetricInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.MetricInfo
      .builder()
      .optionallyWith(
        metricNamespace.map(value =>
          QuotaMetricNamespace.unwrap(value): java.lang.String
        )
      )(_.metricNamespace)
      .optionallyWith(
        metricName.map(value => QuotaMetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        metricDimensions.map(value =>
          value
            .map({ case (key, value) =>
              (MetricDimensionName
                .unwrap(key): java.lang.String) -> (MetricDimensionValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metricDimensions)
      .optionallyWith(
        metricStatisticRecommendation.map(value =>
          Statistic.unwrap(value): java.lang.String
        )
      )(_.metricStatisticRecommendation)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.MetricInfo.ReadOnly =
    zio.aws.servicequotas.model.MetricInfo.wrap(buildAwsValue())
}
object MetricInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.MetricInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.MetricInfo =
      zio.aws.servicequotas.model.MetricInfo(
        metricNamespace.map(value => value),
        metricName.map(value => value),
        metricDimensions.map(value => value),
        metricStatisticRecommendation.map(value => value)
      )
    def metricNamespace: Optional[QuotaMetricNamespace]
    def metricName: Optional[QuotaMetricName]
    def metricDimensions
        : Optional[Map[MetricDimensionName, MetricDimensionValue]]
    def metricStatisticRecommendation: Optional[Statistic]
    def getMetricNamespace: ZIO[Any, AwsError, QuotaMetricNamespace] =
      AwsError.unwrapOptionField("metricNamespace", metricNamespace)
    def getMetricName: ZIO[Any, AwsError, QuotaMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricDimensions
        : ZIO[Any, AwsError, Map[MetricDimensionName, MetricDimensionValue]] =
      AwsError.unwrapOptionField("metricDimensions", metricDimensions)
    def getMetricStatisticRecommendation: ZIO[Any, AwsError, Statistic] =
      AwsError.unwrapOptionField(
        "metricStatisticRecommendation",
        metricStatisticRecommendation
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.MetricInfo
  ) extends zio.aws.servicequotas.model.MetricInfo.ReadOnly {
    override val metricNamespace: Optional[QuotaMetricNamespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricNamespace())
        .map(value =>
          zio.aws.servicequotas.model.primitives.QuotaMetricNamespace(value)
        )
    override val metricName: Optional[QuotaMetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value =>
        zio.aws.servicequotas.model.primitives.QuotaMetricName(value)
      )
    override val metricDimensions
        : Optional[Map[MetricDimensionName, MetricDimensionValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.servicequotas.model.primitives.MetricDimensionName(
                key
              ) -> zio.aws.servicequotas.model.primitives
                .MetricDimensionValue(value)
            })
            .toMap
        )
    override val metricStatisticRecommendation: Optional[Statistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricStatisticRecommendation())
        .map(value => zio.aws.servicequotas.model.primitives.Statistic(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.MetricInfo
  ): zio.aws.servicequotas.model.MetricInfo.ReadOnly = new Wrapper(impl)
}
