package zio.aws.servicequotas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRequestedServiceQuotaChangeResponse(
    requestedQuota: Optional[
      zio.aws.servicequotas.model.RequestedServiceQuotaChange
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse = {
    import GetRequestedServiceQuotaChangeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse
      .builder()
      .optionallyWith(requestedQuota.map(value => value.buildAwsValue()))(
        _.requestedQuota
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse.ReadOnly =
    zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse
      .wrap(buildAwsValue())
}
object GetRequestedServiceQuotaChangeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse =
      zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse(
        requestedQuota.map(value => value.asEditable)
      )
    def requestedQuota: Optional[
      zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
    ]
    def getRequestedQuota: ZIO[
      Any,
      AwsError,
      zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
    ] = AwsError.unwrapOptionField("requestedQuota", requestedQuota)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse
  ) extends zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse.ReadOnly {
    override val requestedQuota: Optional[
      zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requestedQuota())
      .map(value =>
        zio.aws.servicequotas.model.RequestedServiceQuotaChange.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse
  ): zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse.ReadOnly =
    new Wrapper(impl)
}
