package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{
  QuotaValue,
  QuotaCode,
  ServiceCode
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RequestServiceQuotaIncreaseRequest(
    serviceCode: ServiceCode,
    quotaCode: QuotaCode,
    desiredValue: QuotaValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest = {
    import RequestServiceQuotaIncreaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest
      .builder()
      .serviceCode(ServiceCode.unwrap(serviceCode): java.lang.String)
      .quotaCode(QuotaCode.unwrap(quotaCode): java.lang.String)
      .desiredValue(QuotaValue.unwrap(desiredValue): java.lang.Double)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest.ReadOnly =
    zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest
      .wrap(buildAwsValue())
}
object RequestServiceQuotaIncreaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest =
      zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest(
        serviceCode,
        quotaCode,
        desiredValue
      )
    def serviceCode: ServiceCode
    def quotaCode: QuotaCode
    def desiredValue: QuotaValue
    def getServiceCode: ZIO[Any, Nothing, ServiceCode] =
      ZIO.succeed(serviceCode)
    def getQuotaCode: ZIO[Any, Nothing, QuotaCode] = ZIO.succeed(quotaCode)
    def getDesiredValue: ZIO[Any, Nothing, QuotaValue] =
      ZIO.succeed(desiredValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest
  ) extends zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest.ReadOnly {
    override val serviceCode: ServiceCode =
      zio.aws.servicequotas.model.primitives.ServiceCode(impl.serviceCode())
    override val quotaCode: QuotaCode =
      zio.aws.servicequotas.model.primitives.QuotaCode(impl.quotaCode())
    override val desiredValue: QuotaValue =
      zio.aws.servicequotas.model.primitives.QuotaValue(impl.desiredValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest
  ): zio.aws.servicequotas.model.RequestServiceQuotaIncreaseRequest.ReadOnly =
    new Wrapper(impl)
}
