package zio.aws.servicequotas.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.servicequotas.model.primitives.{
  MaxResults,
  NextToken,
  AwsRegion,
  ServiceCode
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListServiceQuotaIncreaseRequestsInTemplateRequest(
    serviceCode: Optional[ServiceCode] = Optional.Absent,
    awsRegion: Optional[AwsRegion] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest = {
    import ListServiceQuotaIncreaseRequestsInTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest
      .builder()
      .optionallyWith(
        serviceCode.map(value => ServiceCode.unwrap(value): java.lang.String)
      )(_.serviceCode)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest.ReadOnly =
    zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest
      .wrap(buildAwsValue())
}
object ListServiceQuotaIncreaseRequestsInTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest =
      zio.aws.servicequotas.model
        .ListServiceQuotaIncreaseRequestsInTemplateRequest(
          serviceCode.map(value => value),
          awsRegion.map(value => value),
          nextToken.map(value => value),
          maxResults.map(value => value)
        )
    def serviceCode: Optional[ServiceCode]
    def awsRegion: Optional[AwsRegion]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getServiceCode: ZIO[Any, AwsError, ServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest
  ) extends zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest.ReadOnly {
    override val serviceCode: Optional[ServiceCode] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCode())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceCode(value))
    override val awsRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.servicequotas.model.primitives.AwsRegion(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.servicequotas.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest
  ): zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
