package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAwsDefaultServiceQuotasResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    quotas: Optional[Iterable[zio.aws.servicequotas.model.ServiceQuota]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse = {
    import ListAwsDefaultServiceQuotasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        quotas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.quotas)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse.ReadOnly =
    zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse
      .wrap(buildAwsValue())
}
object ListAwsDefaultServiceQuotasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse =
      zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse(
        nextToken.map(value => value),
        quotas.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def quotas
        : Optional[List[zio.aws.servicequotas.model.ServiceQuota.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQuotas: ZIO[Any, AwsError, List[
      zio.aws.servicequotas.model.ServiceQuota.ReadOnly
    ]] = AwsError.unwrapOptionField("quotas", quotas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse
  ) extends zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val quotas
        : Optional[List[zio.aws.servicequotas.model.ServiceQuota.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quotas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicequotas.model.ServiceQuota.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse
  ): zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse.ReadOnly =
    new Wrapper(impl)
}
