package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceARN: AmazonResourceName,
    tags: Iterable[zio.aws.servicequotas.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.TagResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.TagResourceRequest.ReadOnly =
    zio.aws.servicequotas.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.TagResourceRequest =
      zio.aws.servicequotas.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: AmazonResourceName
    def tags: List[zio.aws.servicequotas.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.servicequotas.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.TagResourceRequest
  ) extends zio.aws.servicequotas.model.TagResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.servicequotas.model.primitives
        .AmazonResourceName(impl.resourceARN())
    override val tags: List[zio.aws.servicequotas.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.servicequotas.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.TagResourceRequest
  ): zio.aws.servicequotas.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
