package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{
  QuotaUnit,
  QuotaAdjustable,
  QuotaCode,
  GlobalQuota,
  QuotaArn,
  ServiceCode,
  QuotaValue,
  QuotaName,
  ServiceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ServiceQuota(
    serviceCode: Option[ServiceCode] = None,
    serviceName: Option[ServiceName] = None,
    quotaArn: Option[QuotaArn] = None,
    quotaCode: Option[QuotaCode] = None,
    quotaName: Option[QuotaName] = None,
    value: Option[QuotaValue] = None,
    unit: Option[QuotaUnit] = None,
    adjustable: Option[QuotaAdjustable] = None,
    globalQuota: Option[GlobalQuota] = None,
    usageMetric: Option[zio.aws.servicequotas.model.MetricInfo] = None,
    period: Option[zio.aws.servicequotas.model.QuotaPeriod] = None,
    errorReason: Option[zio.aws.servicequotas.model.ErrorReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ServiceQuota = {
    import ServiceQuota.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ServiceQuota
      .builder()
      .optionallyWith(
        serviceCode.map(value => ServiceCode.unwrap(value): java.lang.String)
      )(_.serviceCode)
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        quotaArn.map(value => QuotaArn.unwrap(value): java.lang.String)
      )(_.quotaArn)
      .optionallyWith(
        quotaCode.map(value => QuotaCode.unwrap(value): java.lang.String)
      )(_.quotaCode)
      .optionallyWith(
        quotaName.map(value => QuotaName.unwrap(value): java.lang.String)
      )(_.quotaName)
      .optionallyWith(
        value.map(value => QuotaValue.unwrap(value): java.lang.Double)
      )(_.value)
      .optionallyWith(
        unit.map(value => QuotaUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .optionallyWith(
        adjustable.map(value =>
          QuotaAdjustable.unwrap(value): java.lang.Boolean
        )
      )(_.adjustable)
      .optionallyWith(
        globalQuota.map(value => GlobalQuota.unwrap(value): java.lang.Boolean)
      )(_.globalQuota)
      .optionallyWith(usageMetric.map(value => value.buildAwsValue()))(
        _.usageMetric
      )
      .optionallyWith(period.map(value => value.buildAwsValue()))(_.period)
      .optionallyWith(errorReason.map(value => value.buildAwsValue()))(
        _.errorReason
      )
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.ServiceQuota.ReadOnly =
    zio.aws.servicequotas.model.ServiceQuota.wrap(buildAwsValue())
}
object ServiceQuota {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ServiceQuota
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.ServiceQuota =
      zio.aws.servicequotas.model.ServiceQuota(
        serviceCode.map(value => value),
        serviceName.map(value => value),
        quotaArn.map(value => value),
        quotaCode.map(value => value),
        quotaName.map(value => value),
        value.map(value => value),
        unit.map(value => value),
        adjustable.map(value => value),
        globalQuota.map(value => value),
        usageMetric.map(value => value.asEditable),
        period.map(value => value.asEditable),
        errorReason.map(value => value.asEditable)
      )
    def serviceCode: Option[ServiceCode]
    def serviceName: Option[ServiceName]
    def quotaArn: Option[QuotaArn]
    def quotaCode: Option[QuotaCode]
    def quotaName: Option[QuotaName]
    def value: Option[QuotaValue]
    def unit: Option[QuotaUnit]
    def adjustable: Option[QuotaAdjustable]
    def globalQuota: Option[GlobalQuota]
    def usageMetric: Option[zio.aws.servicequotas.model.MetricInfo.ReadOnly]
    def period: Option[zio.aws.servicequotas.model.QuotaPeriod.ReadOnly]
    def errorReason: Option[zio.aws.servicequotas.model.ErrorReason.ReadOnly]
    def getServiceCode: ZIO[Any, AwsError, ServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getQuotaArn: ZIO[Any, AwsError, QuotaArn] =
      AwsError.unwrapOptionField("quotaArn", quotaArn)
    def getQuotaCode: ZIO[Any, AwsError, QuotaCode] =
      AwsError.unwrapOptionField("quotaCode", quotaCode)
    def getQuotaName: ZIO[Any, AwsError, QuotaName] =
      AwsError.unwrapOptionField("quotaName", quotaName)
    def getValue: ZIO[Any, AwsError, QuotaValue] =
      AwsError.unwrapOptionField("value", value)
    def getUnit: ZIO[Any, AwsError, QuotaUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getAdjustable: ZIO[Any, AwsError, QuotaAdjustable] =
      AwsError.unwrapOptionField("adjustable", adjustable)
    def getGlobalQuota: ZIO[Any, AwsError, GlobalQuota] =
      AwsError.unwrapOptionField("globalQuota", globalQuota)
    def getUsageMetric
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.MetricInfo.ReadOnly] =
      AwsError.unwrapOptionField("usageMetric", usageMetric)
    def getPeriod
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.QuotaPeriod.ReadOnly] =
      AwsError.unwrapOptionField("period", period)
    def getErrorReason
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.ErrorReason.ReadOnly] =
      AwsError.unwrapOptionField("errorReason", errorReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ServiceQuota
  ) extends zio.aws.servicequotas.model.ServiceQuota.ReadOnly {
    override val serviceCode: Option[ServiceCode] = scala
      .Option(impl.serviceCode())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceCode(value))
    override val serviceName: Option[ServiceName] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceName(value))
    override val quotaArn: Option[QuotaArn] = scala
      .Option(impl.quotaArn())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaArn(value))
    override val quotaCode: Option[QuotaCode] = scala
      .Option(impl.quotaCode())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaCode(value))
    override val quotaName: Option[QuotaName] = scala
      .Option(impl.quotaName())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaName(value))
    override val value: Option[QuotaValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaValue(value))
    override val unit: Option[QuotaUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaUnit(value))
    override val adjustable: Option[QuotaAdjustable] = scala
      .Option(impl.adjustable())
      .map(value =>
        zio.aws.servicequotas.model.primitives.QuotaAdjustable(value)
      )
    override val globalQuota: Option[GlobalQuota] = scala
      .Option(impl.globalQuota())
      .map(value => zio.aws.servicequotas.model.primitives.GlobalQuota(value))
    override val usageMetric
        : Option[zio.aws.servicequotas.model.MetricInfo.ReadOnly] = scala
      .Option(impl.usageMetric())
      .map(value => zio.aws.servicequotas.model.MetricInfo.wrap(value))
    override val period
        : Option[zio.aws.servicequotas.model.QuotaPeriod.ReadOnly] = scala
      .Option(impl.period())
      .map(value => zio.aws.servicequotas.model.QuotaPeriod.wrap(value))
    override val errorReason
        : Option[zio.aws.servicequotas.model.ErrorReason.ReadOnly] = scala
      .Option(impl.errorReason())
      .map(value => zio.aws.servicequotas.model.ErrorReason.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ServiceQuota
  ): zio.aws.servicequotas.model.ServiceQuota.ReadOnly = new Wrapper(impl)
}
