package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{
  CustomerServiceEngagementId,
  QuotaUnit,
  QuotaCode,
  GlobalQuota,
  QuotaArn,
  DateTime,
  ServiceCode,
  RequestId,
  QuotaValue,
  QuotaName,
  ServiceName,
  Requester
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RequestedServiceQuotaChange(
    id: Option[RequestId] = None,
    caseId: Option[CustomerServiceEngagementId] = None,
    serviceCode: Option[ServiceCode] = None,
    serviceName: Option[ServiceName] = None,
    quotaCode: Option[QuotaCode] = None,
    quotaName: Option[QuotaName] = None,
    desiredValue: Option[QuotaValue] = None,
    status: Option[zio.aws.servicequotas.model.RequestStatus] = None,
    created: Option[DateTime] = None,
    lastUpdated: Option[DateTime] = None,
    requester: Option[Requester] = None,
    quotaArn: Option[QuotaArn] = None,
    globalQuota: Option[GlobalQuota] = None,
    unit: Option[QuotaUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange = {
    import RequestedServiceQuotaChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange
      .builder()
      .optionallyWith(
        id.map(value => RequestId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        caseId.map(value =>
          CustomerServiceEngagementId.unwrap(value): java.lang.String
        )
      )(_.caseId)
      .optionallyWith(
        serviceCode.map(value => ServiceCode.unwrap(value): java.lang.String)
      )(_.serviceCode)
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        quotaCode.map(value => QuotaCode.unwrap(value): java.lang.String)
      )(_.quotaCode)
      .optionallyWith(
        quotaName.map(value => QuotaName.unwrap(value): java.lang.String)
      )(_.quotaName)
      .optionallyWith(
        desiredValue.map(value => QuotaValue.unwrap(value): java.lang.Double)
      )(_.desiredValue)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        lastUpdated.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        requester.map(value => Requester.unwrap(value): java.lang.String)
      )(_.requester)
      .optionallyWith(
        quotaArn.map(value => QuotaArn.unwrap(value): java.lang.String)
      )(_.quotaArn)
      .optionallyWith(
        globalQuota.map(value => GlobalQuota.unwrap(value): java.lang.Boolean)
      )(_.globalQuota)
      .optionallyWith(
        unit.map(value => QuotaUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly =
    zio.aws.servicequotas.model.RequestedServiceQuotaChange
      .wrap(buildAwsValue())
}
object RequestedServiceQuotaChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.RequestedServiceQuotaChange =
      zio.aws.servicequotas.model.RequestedServiceQuotaChange(
        id.map(value => value),
        caseId.map(value => value),
        serviceCode.map(value => value),
        serviceName.map(value => value),
        quotaCode.map(value => value),
        quotaName.map(value => value),
        desiredValue.map(value => value),
        status.map(value => value),
        created.map(value => value),
        lastUpdated.map(value => value),
        requester.map(value => value),
        quotaArn.map(value => value),
        globalQuota.map(value => value),
        unit.map(value => value)
      )
    def id: Option[RequestId]
    def caseId: Option[CustomerServiceEngagementId]
    def serviceCode: Option[ServiceCode]
    def serviceName: Option[ServiceName]
    def quotaCode: Option[QuotaCode]
    def quotaName: Option[QuotaName]
    def desiredValue: Option[QuotaValue]
    def status: Option[zio.aws.servicequotas.model.RequestStatus]
    def created: Option[DateTime]
    def lastUpdated: Option[DateTime]
    def requester: Option[Requester]
    def quotaArn: Option[QuotaArn]
    def globalQuota: Option[GlobalQuota]
    def unit: Option[QuotaUnit]
    def getId: ZIO[Any, AwsError, RequestId] =
      AwsError.unwrapOptionField("id", id)
    def getCaseId: ZIO[Any, AwsError, CustomerServiceEngagementId] =
      AwsError.unwrapOptionField("caseId", caseId)
    def getServiceCode: ZIO[Any, AwsError, ServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getQuotaCode: ZIO[Any, AwsError, QuotaCode] =
      AwsError.unwrapOptionField("quotaCode", quotaCode)
    def getQuotaName: ZIO[Any, AwsError, QuotaName] =
      AwsError.unwrapOptionField("quotaName", quotaName)
    def getDesiredValue: ZIO[Any, AwsError, QuotaValue] =
      AwsError.unwrapOptionField("desiredValue", desiredValue)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.RequestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getLastUpdated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getRequester: ZIO[Any, AwsError, Requester] =
      AwsError.unwrapOptionField("requester", requester)
    def getQuotaArn: ZIO[Any, AwsError, QuotaArn] =
      AwsError.unwrapOptionField("quotaArn", quotaArn)
    def getGlobalQuota: ZIO[Any, AwsError, GlobalQuota] =
      AwsError.unwrapOptionField("globalQuota", globalQuota)
    def getUnit: ZIO[Any, AwsError, QuotaUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange
  ) extends zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly {
    override val id: Option[RequestId] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicequotas.model.primitives.RequestId(value))
    override val caseId: Option[CustomerServiceEngagementId] = scala
      .Option(impl.caseId())
      .map(value =>
        zio.aws.servicequotas.model.primitives
          .CustomerServiceEngagementId(value)
      )
    override val serviceCode: Option[ServiceCode] = scala
      .Option(impl.serviceCode())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceCode(value))
    override val serviceName: Option[ServiceName] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceName(value))
    override val quotaCode: Option[QuotaCode] = scala
      .Option(impl.quotaCode())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaCode(value))
    override val quotaName: Option[QuotaName] = scala
      .Option(impl.quotaName())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaName(value))
    override val desiredValue: Option[QuotaValue] = scala
      .Option(impl.desiredValue())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaValue(value))
    override val status: Option[zio.aws.servicequotas.model.RequestStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.servicequotas.model.RequestStatus.wrap(value))
    override val created: Option[DateTime] = scala
      .Option(impl.created())
      .map(value => zio.aws.servicequotas.model.primitives.DateTime(value))
    override val lastUpdated: Option[DateTime] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.servicequotas.model.primitives.DateTime(value))
    override val requester: Option[Requester] = scala
      .Option(impl.requester())
      .map(value => zio.aws.servicequotas.model.primitives.Requester(value))
    override val quotaArn: Option[QuotaArn] = scala
      .Option(impl.quotaArn())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaArn(value))
    override val globalQuota: Option[GlobalQuota] = scala
      .Option(impl.globalQuota())
      .map(value => zio.aws.servicequotas.model.primitives.GlobalQuota(value))
    override val unit: Option[QuotaUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaUnit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange
  ): zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly =
    new Wrapper(impl)
}
