package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{
  QuotaValue,
  AwsRegion,
  ServiceCode,
  QuotaCode
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutServiceQuotaIncreaseRequestIntoTemplateRequest(
    quotaCode: QuotaCode,
    serviceCode: ServiceCode,
    awsRegion: AwsRegion,
    desiredValue: QuotaValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest = {
    import PutServiceQuotaIncreaseRequestIntoTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest
      .builder()
      .quotaCode(QuotaCode.unwrap(quotaCode): java.lang.String)
      .serviceCode(ServiceCode.unwrap(serviceCode): java.lang.String)
      .awsRegion(AwsRegion.unwrap(awsRegion): java.lang.String)
      .desiredValue(QuotaValue.unwrap(desiredValue): java.lang.Double)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest.ReadOnly =
    zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest
      .wrap(buildAwsValue())
}
object PutServiceQuotaIncreaseRequestIntoTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest =
      zio.aws.servicequotas.model
        .PutServiceQuotaIncreaseRequestIntoTemplateRequest(
          quotaCode,
          serviceCode,
          awsRegion,
          desiredValue
        )
    def quotaCode: QuotaCode
    def serviceCode: ServiceCode
    def awsRegion: AwsRegion
    def desiredValue: QuotaValue
    def getQuotaCode: ZIO[Any, Nothing, QuotaCode] = ZIO.succeed(quotaCode)
    def getServiceCode: ZIO[Any, Nothing, ServiceCode] =
      ZIO.succeed(serviceCode)
    def getAwsRegion: ZIO[Any, Nothing, AwsRegion] = ZIO.succeed(awsRegion)
    def getDesiredValue: ZIO[Any, Nothing, QuotaValue] =
      ZIO.succeed(desiredValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest
  ) extends zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest.ReadOnly {
    override val quotaCode: QuotaCode =
      zio.aws.servicequotas.model.primitives.QuotaCode(impl.quotaCode())
    override val serviceCode: ServiceCode =
      zio.aws.servicequotas.model.primitives.ServiceCode(impl.serviceCode())
    override val awsRegion: AwsRegion =
      zio.aws.servicequotas.model.primitives.AwsRegion(impl.awsRegion())
    override val desiredValue: QuotaValue =
      zio.aws.servicequotas.model.primitives.QuotaValue(impl.desiredValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest
  ): zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
