package zio.aws.servicequotas.model
import scala.jdk.CollectionConverters.*
sealed trait PeriodUnit {
  def unwrap: software.amazon.awssdk.services.servicequotas.model.PeriodUnit
}
object PeriodUnit {
  def wrap(
      value: software.amazon.awssdk.services.servicequotas.model.PeriodUnit
  ): zio.aws.servicequotas.model.PeriodUnit = value match {
    case software.amazon.awssdk.services.servicequotas.model.PeriodUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicequotas.model.PeriodUnit.MICROSECOND =>
      val r = MICROSECOND
      r
    case software.amazon.awssdk.services.servicequotas.model.PeriodUnit.MILLISECOND =>
      val r = MILLISECOND
      r
    case software.amazon.awssdk.services.servicequotas.model.PeriodUnit.SECOND =>
      val r = SECOND
      r
    case software.amazon.awssdk.services.servicequotas.model.PeriodUnit.MINUTE =>
      val r = MINUTE
      r
    case software.amazon.awssdk.services.servicequotas.model.PeriodUnit.HOUR =>
      val r = HOUR
      r
    case software.amazon.awssdk.services.servicequotas.model.PeriodUnit.DAY =>
      val r = DAY
      r
    case software.amazon.awssdk.services.servicequotas.model.PeriodUnit.WEEK =>
      val r = WEEK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicequotas.model.PeriodUnit {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.PeriodUnit =
      software.amazon.awssdk.services.servicequotas.model.PeriodUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object MICROSECOND extends zio.aws.servicequotas.model.PeriodUnit {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.PeriodUnit =
      software.amazon.awssdk.services.servicequotas.model.PeriodUnit.MICROSECOND
  }
  case object MILLISECOND extends zio.aws.servicequotas.model.PeriodUnit {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.PeriodUnit =
      software.amazon.awssdk.services.servicequotas.model.PeriodUnit.MILLISECOND
  }
  case object SECOND extends zio.aws.servicequotas.model.PeriodUnit {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.PeriodUnit =
      software.amazon.awssdk.services.servicequotas.model.PeriodUnit.SECOND
  }
  case object MINUTE extends zio.aws.servicequotas.model.PeriodUnit {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.PeriodUnit =
      software.amazon.awssdk.services.servicequotas.model.PeriodUnit.MINUTE
  }
  case object HOUR extends zio.aws.servicequotas.model.PeriodUnit {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.PeriodUnit =
      software.amazon.awssdk.services.servicequotas.model.PeriodUnit.HOUR
  }
  case object DAY extends zio.aws.servicequotas.model.PeriodUnit {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.PeriodUnit =
      software.amazon.awssdk.services.servicequotas.model.PeriodUnit.DAY
  }
  case object WEEK extends zio.aws.servicequotas.model.PeriodUnit {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.PeriodUnit =
      software.amazon.awssdk.services.servicequotas.model.PeriodUnit.WEEK
  }
}
