package zio.aws.servicequotas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Option[Iterable[zio.aws.servicequotas.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.servicequotas.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.ListTagsForResourceResponse =
      zio.aws.servicequotas.model.ListTagsForResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Option[List[zio.aws.servicequotas.model.Tag.ReadOnly]]
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicequotas.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceResponse
  ) extends zio.aws.servicequotas.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[List[zio.aws.servicequotas.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicequotas.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceResponse
  ): zio.aws.servicequotas.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
