package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListServicesResponse(
    nextToken: Option[NextToken] = None,
    services: Option[Iterable[zio.aws.servicequotas.model.ServiceInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListServicesResponse = {
    import ListServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListServicesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.ListServicesResponse.ReadOnly =
    zio.aws.servicequotas.model.ListServicesResponse.wrap(buildAwsValue())
}
object ListServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.ListServicesResponse =
      zio.aws.servicequotas.model.ListServicesResponse(
        nextToken.map(value => value),
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def services: Option[List[zio.aws.servicequotas.model.ServiceInfo.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServices: ZIO[Any, AwsError, List[
      zio.aws.servicequotas.model.ServiceInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("services", services)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServicesResponse
  ) extends zio.aws.servicequotas.model.ListServicesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val services
        : Option[List[zio.aws.servicequotas.model.ServiceInfo.ReadOnly]] = scala
      .Option(impl.services())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicequotas.model.ServiceInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServicesResponse
  ): zio.aws.servicequotas.model.ListServicesResponse.ReadOnly = new Wrapper(
    impl
  )
}
