package zio.aws.servicequotas.model
import java.lang.Integer
import zio.aws.servicequotas.model.primitives.{
  MaxResults,
  NextToken,
  ServiceCode
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListServiceQuotasRequest(
    serviceCode: ServiceCode,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest = {
    import ListServiceQuotasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest
      .builder()
      .serviceCode(ServiceCode.unwrap(serviceCode): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListServiceQuotasRequest.ReadOnly =
    zio.aws.servicequotas.model.ListServiceQuotasRequest.wrap(buildAwsValue())
}
object ListServiceQuotasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.ListServiceQuotasRequest =
      zio.aws.servicequotas.model.ListServiceQuotasRequest(
        serviceCode,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceCode: ServiceCode
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getServiceCode: ZIO[Any, Nothing, ServiceCode] =
      ZIO.succeed(serviceCode)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest
  ) extends zio.aws.servicequotas.model.ListServiceQuotasRequest.ReadOnly {
    override val serviceCode: ServiceCode =
      zio.aws.servicequotas.model.primitives.ServiceCode(impl.serviceCode())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.servicequotas.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest
  ): zio.aws.servicequotas.model.ListServiceQuotasRequest.ReadOnly =
    new Wrapper(impl)
}
