package zio.aws.servicequotas.model
import java.lang.Integer
import zio.aws.servicequotas.model.primitives.{
  MaxResults,
  NextToken,
  QuotaCode,
  ServiceCode
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRequestedServiceQuotaChangeHistoryByQuotaRequest(
    serviceCode: ServiceCode,
    quotaCode: QuotaCode,
    status: Option[zio.aws.servicequotas.model.RequestStatus] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest = {
    import ListRequestedServiceQuotaChangeHistoryByQuotaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
      .builder()
      .serviceCode(ServiceCode.unwrap(serviceCode): java.lang.String)
      .quotaCode(QuotaCode.unwrap(quotaCode): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest.ReadOnly =
    zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
      .wrap(buildAwsValue())
}
object ListRequestedServiceQuotaChangeHistoryByQuotaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest =
      zio.aws.servicequotas.model
        .ListRequestedServiceQuotaChangeHistoryByQuotaRequest(
          serviceCode,
          quotaCode,
          status.map(value => value),
          nextToken.map(value => value),
          maxResults.map(value => value)
        )
    def serviceCode: ServiceCode
    def quotaCode: QuotaCode
    def status: Option[zio.aws.servicequotas.model.RequestStatus]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getServiceCode: ZIO[Any, Nothing, ServiceCode] =
      ZIO.succeed(serviceCode)
    def getQuotaCode: ZIO[Any, Nothing, QuotaCode] = ZIO.succeed(quotaCode)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.RequestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
  ) extends zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest.ReadOnly {
    override val serviceCode: ServiceCode =
      zio.aws.servicequotas.model.primitives.ServiceCode(impl.serviceCode())
    override val quotaCode: QuotaCode =
      zio.aws.servicequotas.model.primitives.QuotaCode(impl.quotaCode())
    override val status: Option[zio.aws.servicequotas.model.RequestStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.servicequotas.model.RequestStatus.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.servicequotas.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
  ): zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest.ReadOnly =
    new Wrapper(impl)
}
