package zio.aws.servicequotas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetServiceQuotaResponse(
    quota: Option[zio.aws.servicequotas.model.ServiceQuota] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse = {
    import GetServiceQuotaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse
      .builder()
      .optionallyWith(quota.map(value => value.buildAwsValue()))(_.quota)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.GetServiceQuotaResponse.ReadOnly =
    zio.aws.servicequotas.model.GetServiceQuotaResponse.wrap(buildAwsValue())
}
object GetServiceQuotaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.GetServiceQuotaResponse =
      zio.aws.servicequotas.model
        .GetServiceQuotaResponse(quota.map(value => value.asEditable))
    def quota: Option[zio.aws.servicequotas.model.ServiceQuota.ReadOnly]
    def getQuota: ZIO[
      Any,
      AwsError,
      zio.aws.servicequotas.model.ServiceQuota.ReadOnly
    ] = AwsError.unwrapOptionField("quota", quota)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse
  ) extends zio.aws.servicequotas.model.GetServiceQuotaResponse.ReadOnly {
    override val quota
        : Option[zio.aws.servicequotas.model.ServiceQuota.ReadOnly] = scala
      .Option(impl.quota())
      .map(value => zio.aws.servicequotas.model.ServiceQuota.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse
  ): zio.aws.servicequotas.model.GetServiceQuotaResponse.ReadOnly = new Wrapper(
    impl
  )
}
